<?php
function register_service_post_type()
{
    $labels = array(
        'name'                  => 'Services',
        'singular_name'         => 'Service',
        'menu_name'            => 'Services',
        'add_new'              => 'Add New Service',
        'add_new_item'         => 'Add New Service',
        'edit_item'            => 'Edit Service',
        'new_item'             => 'New Service',
        'view_item'            => 'View Service',
        'search_items'         => 'Search Services',
        'not_found'            => 'No services found',
        'not_found_in_trash'   => 'No services found in Trash'
    );

    $args = array(
        'labels'              => $labels,
        'public'              => true,
        'has_archive'         => true,
        'publicly_queryable'  => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_rest'        => true,
        'menu_icon'           => 'dashicons-building',
        'supports'            => array('title', 'editor', 'thumbnail', 'excerpt'),
        'rewrite'             => array('slug' => 'services'),
        'menu_position'       => 5,
    );

    register_post_type('service', $args);
}
add_action('init', 'register_service_post_type');

// Register Service Categories
function register_service_categories()
{
    $labels = array(
        'name'              => 'Service Categories',
        'singular_name'     => 'Service Category',
        'search_items'      => 'Search Service Categories',
        'all_items'         => 'All Service Categories',
        'parent_item'       => 'Parent Service Category',
        'parent_item_colon' => 'Parent Service Category:',
        'edit_item'         => 'Edit Service Category',
        'update_item'       => 'Update Service Category',
        'add_new_item'      => 'Add New Service Category',
        'new_item_name'     => 'New Service Category Name',
        'menu_name'         => 'Categories'
    );

    $args = array(
        'labels'            => $labels,
        'hierarchical'      => true,
        'show_ui'          => true,
        'show_admin_column' => true,
        'query_var'        => true,
        'rewrite'          => array('slug' => 'service-category'),
        'show_in_rest'     => true
    );

    register_taxonomy('service_category', 'service', $args);
}
add_action('init', 'register_service_categories');

// Add default categories after theme activation
function add_default_service_categories()
{
    wp_insert_term('Modern Design', 'service_category');
    wp_insert_term('Sustainable', 'service_category');
}
add_action('after_switch_theme', 'add_default_service_categories');
