<?php

/**
 * 
 * Demo Imports
 */
//echo trailingslashit(DHAARA_ADDON_PATH) . 'sample-data/contents-demo.xml';
function tp_ocdi_import_files()
{

    return array(
        array(
            'import_file_name'           => 'Home Main',
            'categories'                 => array('Business'),
            'local_import_file'             => trailingslashit(DHAARA_ADDON_PATH) . 'sample-data/contents-demo.xml',
            'local_import_customizer_file' => trailingslashit(DHAARA_ADDON_PATH) . 'sample-data/customizer-data.dat',
            'import_preview_image_url' => plugins_url('assets/img/demo/demo-1.jpg', dirname(__FILE__)),
            'preview_url'                => 'https://demo.colorbee.online/dhaara/',
        ),

    );
}
add_filter('ocdi/import_files', 'tp_ocdi_import_files');


// after demo imports
function tp_ocdi_after_import_setup($demo)
{
    $front_page_id = "";
    $blog_page_id = "";

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title('Home');
    $blog_page_id  = get_page_by_title('Blog');


    update_option('show_on_front', 'page');
    update_option('page_on_front', $front_page_id->ID);
    update_option('page_for_posts', $blog_page_id->ID);


    // Assign menus to their locations.
    $main_menu = get_term_by('name', 'Primary', 'nav_menu');

    set_theme_mod(
        'nav_menu_locations',
        [
            'primary-menu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function in your theme.
        ]
    );

    // Fix Elementor after import
    if (class_exists('\Elementor\Plugin')) {
        // Clear Elementor cache
        \Elementor\Plugin::$instance->files_manager->clear_cache();
        
        // Regenerate CSS files
        if (method_exists('\Elementor\Plugin::$instance->posts_css_manager', 'clear_cache')) {
            \Elementor\Plugin::$instance->posts_css_manager->clear_cache();
        }
        
        // Update Elementor options
        update_option('elementor_scheme_color', null);
        update_option('elementor_scheme_typography', null);
        
        // Force regenerate CSS on next page load
        delete_option('elementor_css_print_method');
        
        // Sync Elementor library
        if (method_exists('\Elementor\Plugin::$instance->templates_manager', 'get_library_manager')) {
            $library_manager = \Elementor\Plugin::$instance->templates_manager->get_library_manager();
            if (method_exists($library_manager, 'sync_library')) {
                $library_manager->sync_library();
            }
        }
    }

    // Clear any caching plugins
    if (function_exists('wp_cache_flush')) {
        wp_cache_flush();
    }
    
    // Clear object cache if available
    if (function_exists('wp_cache_clear_cache')) {
        wp_cache_clear_cache();
    }
}
add_action('ocdi/after_import', 'tp_ocdi_after_import_setup');

function tp_ocdi_plugin_page_setup($default_settings)
{
    $default_settings['parent_slug'] = 'themes.php';
    $default_settings['page_title']  = esc_html__('One Click Demo Import', 'one-click-demo-import');
    $default_settings['menu_title']  = esc_html__('Import Theme Demos', 'one-click-demo-import');
    $default_settings['capability']  = 'import';
    $default_settings['menu_slug']   = 'one-click-demo-import';

    return $default_settings;
}
add_filter('ocdi/plugin_page_setup', 'tp_ocdi_plugin_page_setup');