<?php

/**
 * CTA Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class CTA extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'cta';
    }
    public function get_title()
    {
        return esc_html__('CTA Section', 'plugin-name');
    }
    public function get_icon()
    {
        return 'eicon-call-to-action';
    }
    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'plugin-name'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'heading',
            [
                'label' => esc_html__('Heading', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Ready to Start Your Project?', 'plugin-name'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Let\'s create something extraordinary together', 'plugin-name'),
            ]
        );

        // Button 1 Controls
        $this->add_control(
            'button1_text',
            [
                'label' => esc_html__('Button 1 Text', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Get Quote', 'plugin-name'),
            ]
        );

        $this->add_control(
            'button1_link',
            [
                'label' => esc_html__('Button 1 Link', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => ['url' => '#'],
            ]
        );

        // Button 2 Controls
        $this->add_control(
            'button2_text',
            [
                'label' => esc_html__('Button 2 Text', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Contact Us', 'plugin-name'),
            ]
        );

        $this->add_control(
            'button2_link',
            [
                'label' => esc_html__('Button 2 Link', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => ['url' => '#'],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'plugin-name'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2563EB',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#2563EB';
?>
        <section class="cta-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                </div>
            </div>


            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4 fade-in-effect">
                <div class="space-y-20">
                    <div class="relative p-12 rounded-3xl overflow-hidden">
                        <div style="background-color: <?php echo esc_attr($primary_color); ?>" class="absolute inset-0 "></div>

                        <div class="relative flex flex-col md:flex-row items-center justify-between gap-8">
                            <div class="text-white space-y-4">
                                <h3 class="text-3xl font-bold"><?php echo esc_html($settings['heading']); ?></h3>
                                <p class="text-amber-100"><?php echo esc_html($settings['description']); ?></p>
                            </div>
                            <div class="flex flex-col md:flex-row items-center gap-4">
                                <?php if (!empty($settings['button1_text'])) : ?>
                                    <a style="color: <?php echo esc_attr($primary_color); ?>" href="<?php echo esc_url($settings['button1_link']['url']); ?>" class="px-8 py-4 bg-white font-semibold rounded-xl transition-colors">
                                        <?php echo esc_html($settings['button1_text']); ?>
                                    </a>
                                <?php endif; ?>
                                <a href="<?php echo esc_url($settings['button2_link']['url']); ?>" style="background-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.2)); ?>" class="px-8 py-4 text-white font-semibold rounded-xl transition-colors">
                                    <?php echo esc_html($settings['button2_text']); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }

    protected function content_template()
    {
    ?>
        <# var primaryColor=settings.primary_color || '#2563EB' ; #>
            <section class="cta-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
                <div class="absolute inset-0 -z-10">
                    <div class="absolute inset-0 bg-[linear-gradient(to_right,#8882_1px,transparent_1px),linear-gradient(to_bottom,#8882_1px,transparent_1px)] bg-[size:16rem_16rem] opacity-[0.15]"></div>

                    <div style="background-color: {{ primaryColor }}20" class="absolute w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-blob top-1/3 left-0"></div>
                    <div style="background-color: {{ primaryColor }}20" class="absolute w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-blob animation-delay-2000 top-2/3 right-0"></div>
                    <div style="background-color: {{ primaryColor }}20" class="absolute w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-blob animation-delay-4000 top-1/4 right-1/4"></div>
                </div>

                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <div class="space-y-20">
                        <div style="background-color: {{ primaryColor }}" class="relative p-12 rounded-3xl overflow-hidden">
                            <div class="absolute inset-0"></div>

                            <div class="relative flex flex-col md:flex-row items-center justify-between gap-8">
                                <div class="text-white space-y-4">
                                    <h3 class="text-3xl font-bold">{{{ settings.heading }}}</h3>
                                    <p class="text-amber-100">{{{ settings.description }}}</p>
                                </div>
                                <div class="flex flex-col md:flex-row items-center gap-4">
                                    <# if (settings.button1_text) { #>
                                        <a href="{{ settings.button1_link.url }}" style="color: {{ primaryColor }}" class="px-8 py-4 bg-white font-semibold rounded-xl transition-colors">
                                            {{{ settings.button1_text }}}
                                        </a>
                                        <# } #>
                                            <a href="{{ settings.button2_link.url }}" style="background-color: {{ primaryColor }}20; background-image: linear-gradient(to right, rgba(255,255,255,0.2), rgba(255,255,255,0.2));" class="px-8 py-4 text-white font-semibold rounded-xl transition-colors">
                                                {{{ settings.button2_text }}}
                                            </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
    <?php
    }
}
