<?php

/**
 * FAQ Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class FAQ extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'faq';
    }

    public function get_title()
    {
        return esc_html__('FAQ Section', 'dhaara-addon');
    }

    public function get_icon()
    {
        return 'eicon-help';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        // Header Controls
        $this->start_controls_section(
            'section_header',
            [
                'label' => esc_html__('Header', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'FAQ',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Common', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Questions', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Everything you need to know about our services', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // FAQ Items Controls
        $this->start_controls_section(
            'section_faqs',
            [
                'label' => esc_html__('FAQ Items', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'question',
            [
                'label' => esc_html__('Question', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('FAQ Question', 'dhaara-addon'),
            ]
        );

        $repeater->add_control(
            'answer',
            [
                'label' => esc_html__('Answer', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Your answer here...', 'dhaara-addon'),
                'rows' => 5,
            ]
        );

        $this->add_control(
            'faq_items',
            [
                'label' => esc_html__('FAQ Items', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'question' => 'What types of commercial projects do you handle?',
                        'answer' => 'We handle various types of commercial projects including office buildings, retail spaces, restaurants, and industrial facilities.',
                    ],
                ],
                'title_field' => '{{{ question }}}',
            ]
        );

        $this->end_controls_section();

        // Style Controls
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2563EB',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#2563EB';
?>
        <section class="faq-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                </div>
            </div>

            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        <?php echo esc_html($settings['background_text']); ?>
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect ">
                        <?php echo esc_html($settings['heading_text']); ?>
                        <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1">
                        <?php echo esc_html($settings['section_description']); ?>
                    </p>
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 items-start fade-in-effect effect-2">
                    <?php
                    if (!empty($settings['faq_items'])) {
                        foreach ($settings['faq_items'] as $index => $item) :
                    ?>
                            <div class="bg-white rounded-xl shadow-sm">
                                <button class="w-full flex items-center justify-between p-6 focus:outline-none shadow-sm" onclick="this.parentElement.classList.toggle('active')">
                                    <span class="text-lg font-semibold text-gray-900"><?php echo esc_html($item['question']); ?></span>
                                    <div class="relative ml-2 w-7 h-7">
                                        <div class="absolute inset-0  rounded-full transition-colors duration-300" style="background-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>"></div>
                                        <svg style="color: <?php echo esc_attr($primary_color); ?>" class="absolute inset-0 w-7 h-7 p-2 text-primary-amber transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                                        </svg>
                                    </div>
                                </button>
                                <div class="hidden px-6 pb-6 pt-6">
                                    <div class="text-gray-600 prose prose-sm max-w-none textbox">
                                        <?php echo wp_kses_post($item['answer']); ?>
                                    </div>
                                </div>
                            </div>
                    <?php
                        endforeach;
                    }
                    ?>
                </div>
            </div>
        </section>

        <style>
            .active .hidden {
                display: block;
            }
            .active svg {
                transform: rotate(45deg);
            }
        </style>
    <?php
    }

    protected function content_template()
    {
    ?>
        <# var primaryColor=settings.primary_color || '#2563EB' ; #>
            <section class="faq-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
                <div class="absolute inset-0 -z-10">
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                    </div>
                </div>

                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <div class="relative mb-12 sm:mb-16 text-center z-10">
                        <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                            {{{ settings.background_text }}}
                        </div>
                        <h2 class="relative text-5xl font-bold text-gray-900">
                            {{{ settings.heading_text }}}
                            <span style="color: {{ primaryColor }}">
                                {{{ settings.heading_span }}}
                            </span>
                        </h2>
                        <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto">
                            {{{ settings.section_description }}}
                        </p>
                    </div>

                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 items-start">
                        <# if (settings.faq_items) { #>
                            <# _.each(settings.faq_items, function(item, index) { #>
                                <div class="bg-white rounded-xl shadow-sm">
                                    <button class="w-full flex items-center justify-between p-6 focus:outline-none shadow-sm" onclick="this.parentElement.classList.toggle('active')">
                                        <span class="text-lg font-semibold text-gray-900">{{{ item.question }}}</span>
                                        <div class="relative ml-2 w-7 h-7">
                                            <div style="background-color: {{ primaryColor }}10" class="absolute inset-0   rounded-full transition-colors duration-300"></div>
                                            <svg style="color: {{ primaryColor }}" class="absolute inset-0 w-7 h-7 p-2 text-primary-amber transition-colors duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                                            </svg>
                                        </div>
                                    </button>
                                    <div class="hidden px-6 pb-6 pt-6">
                                        <div class="text-gray-600 prose prose-sm max-w-none textbox">
                                            {{{ item.answer }}}
                                        </div>
                                    </div>
                                </div>
                                <# }); #>
                                    <# } #>
                    </div>
                </div>
            </section>
    <?php
    }
}
