<?php

/**
 * Dynamic Construction Hero Widget
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Hero_Varient_1_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'hero_varient_1';
    }

    public function get_title()
    {
        return esc_html__('Hero Varient 1', 'dhaara-addon');
    }

    public function get_icon()
    {
        return 'eicon-header';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    public function get_keywords()
    {
        return ['hero', 'construction', 'dynamic', 'animated', 'building'];
    }

    public function get_style_depends()
    {
        return ['dynamic-hero-styles'];
    }

    public function get_script_depends()
    {
        return ['dynamic-hero-scripts'];
    }

    protected function register_controls()
    {


        // Hero Content Section
        $this->start_controls_section(
            'hero_content_section',
            [
                'label' => esc_html__('Hero Content', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tagline',
            [
                'label' => esc_html__('Tagline', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'ENGINEERING THE IMPOSSIBLE',
            ]
        );

        $this->add_control(
            'main_heading',
            [
                'label' => esc_html__('Main Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'WE BUILD',
            ]
        );

        $this->add_control(
            'rotating_words',
            [
                'label' => esc_html__('Rotating Words', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'word',
                        'label' => esc_html__('Word', 'dhaara-addon'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => 'DREAMS',
                    ],
                ],
                'default' => [
                    ['word' => 'DREAMS'],
                    ['word' => 'FUTURES'],
                    ['word' => 'LEGACIES'],
                    ['word' => 'MONUMENTS'],
                ],
                'title_field' => '{{{ word }}}',
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'From concept to completion, we transform visions into architectural masterpieces that stand the test of time.',
            ]
        );

        $this->end_controls_section();

        // Feature Box Section
        $this->start_controls_section(
            'feature_box_section',
            [
                'label' => esc_html__('Feature Box', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'precision_title',
            [
                'label' => esc_html__('Precision Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'PRECISION',
            ]
        );

        $this->add_control(
            'precision_icon',
            [
                'label' => esc_html__('Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $this->add_control(
            'precision_description',
            [
                'label' => esc_html__('Precision Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Every millimeter matters in our architectural blueprints',
            ]
        );

        $this->add_control(
            'center_year',
            [
                'label' => esc_html__('Center Year', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '2025',
            ]
        );

        $this->add_control(
            'center_subtitle',
            [
                'label' => esc_html__('Center Subtitle', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'REDEFINING CONSTRUCTION',
            ]
        );

        $this->add_control(
            'innovation_title',
            [
                'label' => esc_html__('Innovation Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'INNOVATION',
            ]
        );
        $this->add_control(
            'innovation_icon',
            [
                'label' => esc_html__('Innovation Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-building',
                    'library' => 'fa-solid',
                ],
            ]
        );



        $this->add_control(
            'innovation_description',
            [
                'label' => esc_html__('Innovation Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Pushing boundaries with cutting-edge technology',
            ]
        );

        $this->end_controls_section();

        // Action Buttons Section
        $this->start_controls_section(
            'action_buttons_section',
            [
                'label' => esc_html__('Action Buttons', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'primary_button_text',
            [
                'label' => esc_html__('Primary Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'START PROJECT →',
            ]
        );

        $this->add_control(
            'primary_button_link',
            [
                'label' => esc_html__('Primary Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'secondary_button_text',
            [
                'label' => esc_html__('Secondary Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'VIEW SHOWCASE',
            ]
        );

        $this->add_control(
            'secondary_button_link',
            [
                'label' => esc_html__('Secondary Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Statistics Section
        $this->start_controls_section(
            'statistics_section',
            [
                'label' => esc_html__('Statistics', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'stats',
            [
                'label' => esc_html__('Statistics', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'stat_value',
                        'label' => esc_html__('Value', 'dhaara-addon'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '500',
                    ],
                    [
                        'name' => 'stat_label',
                        'label' => esc_html__('Label', 'dhaara-addon'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => 'M+ SQ FT BUILT',
                    ],
                    [
                        'name' => 'has_counter',
                        'label' => esc_html__('Animated Counter', 'dhaara-addon'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'yes',
                    ],
                ],
                'default' => [
                    [
                        'stat_value' => '500',
                        'stat_label' => 'M+ SQ FT BUILT',
                        'has_counter' => 'yes',
                    ],
                    [
                        'stat_value' => '15',
                        'stat_label' => 'COUNTRIES',
                        'has_counter' => 'yes',
                    ],
                    [
                        'stat_value' => '24/7',
                        'stat_label' => 'OPERATION',
                        'has_counter' => 'no',
                    ],
                    [
                        'stat_value' => 'ZERO',
                        'stat_label' => 'COMPROMISE',
                        'has_counter' => 'no',
                    ],
                ],
                'title_field' => '{{{ stat_value }}} - {{{ stat_label }}}',
            ]
        );

        $this->end_controls_section();

        // Side Elements Section
        $this->start_controls_section(
            'side_elements_section',
            [
                'label' => esc_html__('Side Elements', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'left_side_text',
            [
                'label' => esc_html__('Left Side Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'ARCHITECTURAL EXCELLENCE',
            ]
        );

        $this->add_control(
            'right_side_text',
            [
                'label' => esc_html__('Right Side Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'SUSTAINABLE FUTURE',
            ]
        );

        $this->end_controls_section();

        // Style Sections
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors & Styling', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Brand Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFB600',
            ]
        );



        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';

?>
        <section class="dynamic-hero-section relative min-h-screen construction-grid 3xl:min-h-full w-full py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Animated Blueprint Lines -->
            <svg class="absolute inset-0 w-full h-full pointer-events-none opacity-30" viewBox="0 0 1000 1000">
                <path class="blueprint-line"  stroke-width="2" fill="none"
                    d="M100,100 L300,100 L300,300 L500,300 L500,200 L700,200 L700,400 L900,400" />
                <path class="blueprint-line"   stroke-width="2" fill="none"
                    d="M200,500 L400,500 L400,700 L600,700 L600,600 L800,600" />
            </svg>
            <!-- Main Content -->
            <div class="relative z-10 flex flex-col justify-center items-center text-center px-6">
                <!-- Dynamic Word Rotation -->
                <div class="mb-12 slide-up-enhanced">
                    <p class="font-semibold text-lg mb-6 tracking-wide" style="color: <?php echo esc_attr($primary_color); ?>">
                        <?php echo esc_html($settings['tagline']); ?>
                    </p>
                    <div class="space-y-6">
                        <h1 class="text-5xl lg:text-7xl font-black leading-tight" style="color: var(--text-color);">
                            <?php echo esc_html($settings['main_heading']); ?>
                        </h1>
                        <div class="word-container text-3xl lg:text-5xl font-black" style="color: <?php echo esc_attr($primary_color); ?>">
                            <?php foreach ($settings['rotating_words'] as $index => $word) : ?>
                                <div class="word-animation <?php echo $index === 0 ? 'active' : ''; ?>" id="word-<?php echo $index; ?>">
                                    <?php
                                    $letters = str_split($word['word']);
                                    foreach ($letters as $letter) : ?>
                                        <span class="word-letter"><?php echo esc_html($letter); ?></span>
                                    <?php endforeach; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>

                <!--  Central Feature Box -->
                <div class="delay-1 mb-12 w-full max-w-5xl floating-enhanced">
                    <div class="feature-box relative backdrop-blur-sm bg-white/80 animated-border rounded-2xl p-6 lg:p-8 shadow-2xl hover:shadow-3xl transition-all duration-500 hover:scale-[1.02] cursor-pointer" style="--primary: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 1)); ?>;--primary-light: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.3)); ?>;">

                        <!-- Animated Corner Brackets -->
                        <div class="corner-bracket absolute -top-2 -left-2 w-6 h-6 border-l-2 border-t-2" style="border-color: <?php echo esc_attr($primary_color); ?>"></div>
                        <div class="corner-bracket absolute -top-2 -right-2 w-6 h-6 border-r-2 border-t-2" style="border-color: <?php echo esc_attr($primary_color); ?>"></div>
                        <div class="corner-bracket absolute -bottom-2 -left-2 w-6 h-6 border-l-2 border-b-2" style="border-color: <?php echo esc_attr($primary_color); ?>"></div>
                        <div class="corner-bracket absolute -bottom-2 -right-2 w-6 h-6 border-r-2 border-b-2" style="border-color: <?php echo esc_attr($primary_color); ?>"></div>

                        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 items-center">
                            <!-- Left: Precision -->
                            <div class="content-section text-center lg:text-left">
                                <div class="icon-pulse w-10 h-10 rounded-full flex items-center justify-center mb-3 mx-auto lg:mx-0 shadow-md text-white" style="background-color: <?php echo esc_attr($primary_color); ?>">
                                    <i class="<?php echo esc_attr($settings['precision_icon']['value']); ?>"></i>
                                </div>
                                <h3 class="text-center text-lg font-bold mb-2">
                                    <?php echo esc_html($settings['precision_title']); ?>
                                </h3>
                                <p class="text-center text-gray-600 text-sm"><?php echo esc_html($settings['precision_description']); ?></p>
                            </div>

                            <!-- Center: Main Message -->
                            <div class="center-divider lg:border-l lg:border-r lg:px-6 py-4 lg:py-0" style="border-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.3)); ?>;--primary-medium: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.2)); ?>;--primary-light: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.0)); ?>;">
                                <div class="content-section text-center">
                                    <div class="year-highlight text-2xl lg:text-3xl font-black mb-2">
                                        <?php echo esc_html($settings['center_year']); ?>
                                    </div>
                                    <p class="font-semibold text-sm lg:text-base" style="color: var(--text-color);">
                                        <?php echo esc_html($settings['center_subtitle']); ?>
                                    </p>
                                    <div class="w-12 h-1 mx-auto mt-3 transition-all duration-300 hover:w-16" style="background-color: <?php echo esc_attr($primary_color); ?>"></div>
                                </div>
                            </div>

                            <!-- Right: Innovation -->
                            <div class="content-section text-center lg:text-right">
                                <div class="icon-pulse w-10 h-10 rounded-full flex items-center justify-center mb-3 mx-auto lg:ml-auto lg:mr-0 shadow-md text-white" style="background-color: <?php echo esc_attr($primary_color); ?>">
                                    <i class="<?php echo esc_attr($settings['innovation_icon']['value']); ?>"></i>
                                </div>
                                <h3 class="text-center text-lg font-bold mb-2 text-glow-hover" style="color: <?php echo esc_attr($primary_color); ?>;--primary-light: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.5)); ?>;">
                                    <?php echo esc_html($settings['innovation_title']); ?>
                                </h3>
                                <p class="text-center text-gray-600 text-sm"><?php echo esc_html($settings['innovation_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Side Elements -->
                    <div class="side-text hidden lg:block   left-auto   font-bold tracking-widest text-xs opacity-60 absolute top-1/2 right-full h-full transform -translate-y-1/2 -translate-x-[50px] [writing-mode:vertical-rl] [text-orientation:sideways] whitespace-nowrap
            " style="color: <?php echo esc_attr($primary_color); ?>">
                        <?php echo esc_html($settings['left_side_text']); ?>
                    </div>
                    <div class="side-text hidden lg:block  font-bold tracking-widest text-xs opacity-60 absolute top-1/2 left-full h-full transform -translate-y-1/2 translate-x-[50px] [writing-mode:vertical-rl] [text-orientation:sideways] whitespace-nowrap" style="color: <?php echo esc_attr($primary_color); ?>">
                        <?php echo esc_html($settings['right_side_text']); ?>
                    </div>
                </div>

                <!-- Action Section -->
                <div class="slide-up-enhanced delay-2">
                    <p class="text-gray-700 text-base lg:text-lg mb-6 max-w-2xl mx-auto">
                        <?php echo esc_html($settings['description']); ?>
                    </p>

                    <div class="flex flex-row gap-4 justify-center">
                        <a href="<?php echo esc_url($settings['primary_button_link']['url']); ?>"

                            class="group inline-flex items-center gap-2 px-6 sm:px-8 py-3 sm:py-4 text-white font-semibold rounded-lg transition-all duration-300 hover:opacity-90 hover:scale-105 shadow-lg"
                            style="background-color: <?php echo esc_attr($primary_color); ?>; border-color: <?php echo esc_attr($primary_color); ?>;">
                            <?php echo esc_html($settings['primary_button_text']); ?>
                        </a>
                        <a href="<?php echo esc_url($settings['secondary_button_link']['url']); ?>"
                            class="border-2 bg-white/50  lg:px-8 lg:py-4    transform  text-sm lg:text-base  hover:shadow-2xl group inline-flex items-center gap-2 px-6 sm:px-8 py-3 sm:py-4 text-white font-semibold rounded-lg transition-all duration-300 hover:opacity-90 hover:scale-105 shadow-lg"
                            style="border-color: <?php echo esc_attr($primary_color); ?>; color: <?php echo esc_attr($primary_color); ?>;">
                            <?php echo esc_html($settings['secondary_button_text']); ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>

<?php
    }
}
 
