<?php

/**
 * Project Details Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Project_Details extends \Elementor\Widget_Base
{

    /**
     * Get widget name.
     */
    public function get_name()
    {
        return 'project_details';
    }

    /**
     * Get widget title.
     */
    public function get_title()
    {
        return esc_html__('Project Details', 'plugin-name');
    }

    /**
     * Get widget icon.
     */
    public function get_icon()
    {
        return 'eicon-info-box';
    }

    /**
     * Get widget categories.
     */
    public function get_categories()
    {
        return ['dhaara'];
    }

    /**
     * Register widget controls.
     */
    protected function register_controls()
    {
        // Header Section Controls
        $this->start_controls_section(
            'section_header',
            [
                'label' => esc_html__('Header', 'plugin-name'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'PROJECTS',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Project', 'plugin-name'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Details', 'plugin-name'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__('Description', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('A comprehensive overview of the Coastal Heights development, highlighting its key features, amenities, and sustainable design elements.', 'plugin-name'),
            ]
        );

        $this->end_controls_section();

        // Project Details Controls
        $this->start_controls_section(
            'section_details',
            [
                'label' => esc_html__('Project Details', 'plugin-name'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $grid_sections_repeater = new \Elementor\Repeater();

        $grid_sections_repeater->add_control(
            'section_heading',
            [
                'label' => esc_html__('Section Heading', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Section Title', 'plugin-name'),
            ]
        );

        $grid_sections_repeater->add_control(
            'section_icon',
            [
                'label' => esc_html__('Section Icon', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $grid_sections_repeater->add_control(
            'section_features',
            [
                'label' => esc_html__('Features List', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => '<ul>
                    <li>Feature 1</li>
                    <li>Feature 2</li>
                    <li>Feature 3</li>
                    <li>Feature 4</li>
                </ul>',
                'description' => esc_html__('Add features as list items. The checkmark icon will be automatically added.', 'plugin-name'),
            ]
        );

        $this->add_control(
            'grid_sections',
            [
                'label' => esc_html__('Grid Sections', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $grid_sections_repeater->get_controls(),
                'default' => [
                    [
                        'section_heading' => 'Building Features',
                        'section_features' => '<ul>
                            <li>45-story luxury towers</li>
                            <li>Floor-to-ceiling windows</li>
                            <li>360° ocean views</li>
                            <li>Private balconies</li>
                        </ul>'
                    ],
                    [
                        'section_heading' => 'Luxury Amenities',
                        'section_features' => '<ul>
                            <li>Infinity pool & spa</li>
                            <li>State-of-the-art fitness center</li>
                            <li>Private cinema</li>
                            <li>Sky lounge & restaurant</li>
                        </ul>'
                    ],
                    [
                        'section_heading' => 'Sustainability',
                        'section_features' => '<ul>
                            <li>LEED Gold certification</li>
                            <li>Solar energy systems</li>
                            <li>Rainwater harvesting</li>
                            <li>Smart building systems</li>
                        </ul>'
                    ],
                ],
                'title_field' => '{{{ section_heading }}}',
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'plugin-name'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2563EB',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend.
     */
    /**
     * Render widget output on the frontend.
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#2563EB';
?>
        <section class="project-details-box relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
                </div>
            </div>

            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2  -translate-x-1/2  text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        <?php echo esc_html($settings['background_text']); ?>
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect">
                        <?php echo esc_html($settings['heading_text']); ?>
                        <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1">
                        <?php echo esc_html($settings['section_description']); ?>
                    </p>
                </div>

                <!-- Details Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8 fade-in-effect effect-2">
                    <?php
                    if (!empty($settings['grid_sections'])) {
                        foreach ($settings['grid_sections'] as $section) :
                    ?>
                            <div class="bg-white p-8 rounded-2xl shadow-xl hover:shadow-2xl transition-shadow duration-300">
                                <!-- Section Icon -->
                                <div style="background-color: <?php echo esc_attr($primary_color . '20'); ?>" class="w-12 h-12 rounded-xl flex items-center justify-center mb-6">
                                    <?php
                                    if (!empty($section['section_icon']['value'])) {
                                        $icon_class = $section['section_icon']['value'];
                                        printf(
                                            '<i class="%s w-6 h-6 flex items-center justify-center" style="color: %s;"></i>',
                                            esc_attr($icon_class),
                                            esc_attr($primary_color)
                                        );
                                    }
                                    ?>
                                </div>
                                <!-- Section Heading -->
                                <h3 class="text-xl font-semibold text-gray-900 mb-3">
                                    <?php echo esc_html($section['section_heading']); ?>
                                </h3>

                                <!-- Section Features -->
                                <div class="space-y-3 text-gray-600 features-list">
                                    <?php
                                    // Get the raw HTML content
                                    echo wp_kses_post($section['section_features']);
                                    ?>
                                </div>
                            </div>
                    <?php
                        endforeach;
                    }
                    ?>
                </div>
            </div>
        </section>
        <?php

        ?>

    <?php
    }

    /**
     * Render widget in the editor.
     */
    /**
     * Render widget output in the editor.
     */
    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#2563EB' ;
            #>
            <section class="project-details-box relative py-16 sm:py-20 lg:py-20 overflow-hidden">
                <!-- Background Elements -->
                <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20"
                            class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animate-blob">
                        </div>
                        <div style="background-color: {{ primaryColor }}20"
                            class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000">
                        </div>
                    </div>
                </div>

                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <!-- Section Header -->
                    <div class="relative mb-12 sm:mb-16 text-center z-10">
                        <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                            {{{ settings.background_text }}}
                        </div>
                        <h2 class="relative text-5xl font-bold text-gray-900">
                            {{{ settings.heading_text }}}
                            <span style="color: {{ primaryColor }}">
                                {{{ settings.heading_span }}}
                            </span>
                        </h2>
                        <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto">
                            {{{ settings.section_description }}}
                        </p>
                    </div>

                    <!-- Details Grid -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                        <# if (settings.grid_sections) { #>
                            <# _.each(settings.grid_sections, function(section) { #>
                                <div class="bg-white p-8 rounded-2xl shadow-sm">
                                    <!-- Section Icon -->
                                    <div style="background-color: {{ primaryColor }}20" class="w-12 h-12 bg-amber-100 rounded-xl flex items-center justify-center mb-6">
                                        <# if (section.section_icon.value) { #>
                                            <i style="color: {{ primaryColor }}" class="{{ section.section_icon.value }} w-6 h-6 text-primary-amber flex items-center justify-center"></i>
                                            <# } #>
                                    </div>

                                    <!-- Section Heading -->
                                    <h3 class="text-xl font-semibold text-gray-900 mb-3">
                                        {{{ section.section_heading }}}
                                    </h3>

                                    <!-- Section Features -->
                                    <div class="space-y-3 text-gray-600 features-list">
                                        {{{ section.section_features }}}

                                    </div>
                                </div>
                                <# }); #>
                                    <# } #>
                    </div>
                </div>
            </section>


    <?php
    }
}
