<?php
class Services_Section_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'services_section';
    }

    public function get_title()
    {
        return 'Services Section';
    }

    public function get_icon()
    {
        return 'eicon-inner-section';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        // Header Section Controls
        $this->start_controls_section(
            'header_section',
            [
                'label' => esc_html__('Header', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'SERVICES',
            ]
        );


        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('What We', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Offer', 'dhaara-addon'),
            ]
        );


        $this->add_control(
            'section_description',
            [
                'label' => __('Section Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Transform your architectural vision into reality with our comprehensive range of services', 'dhaara-addon'),
            ]
        );



        $this->end_controls_section();

        // Featured Service Controls
        $this->start_controls_section(
            'featured_service_section',
            [
                'label' => esc_html__('Service Box', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'featured_service',
            [
                'label' => esc_html__('Select Featured Service', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_services(),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'services_to_show',
            [
                'label' => esc_html__('Number of Regular Services to Show', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'default' => 3,
                'condition' => [
                    'enable_show_more' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'floating_card_title',
            [
                'label' => esc_html__('Floating Card Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Fast Delivery', 'dhaara-addon'),
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'floating_card_description',
            [
                'label' => esc_html__('Floating Card Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Quick turnaround on all projects without compromising quality', 'dhaara-addon'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'learn_more_text',
            [
                'label' => esc_html__('Learn More Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Learn More', 'dhaara-addon'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        // Stats Section Controls
        $this->start_controls_section(
            'stats_section',
            [
                'label' => esc_html__('Stats', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_stats',
            [
                'label' => esc_html__('Show Stats Section', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'stat_number',
            [
                'label' => esc_html__('Number', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '98',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'stat_suffix',
            [
                'label' => esc_html__('Suffix', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '%',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'stat_title',
            [
                'label' => esc_html__('Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Client Satisfaction', 'dhaara-addon'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'stats_list',
            [
                'label' => esc_html__('Stats', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'stat_number' => '98',
                        'stat_suffix' => '%',
                        'stat_title' => esc_html__('Client Satisfaction', 'dhaara-addon'),
                    ],
                    [
                        'stat_number' => '15',
                        'stat_suffix' => '+',
                        'stat_title' => esc_html__('Years Experience', 'dhaara-addon'),
                    ],
                    [
                        'stat_number' => '250',
                        'stat_suffix' => '+',
                        'stat_title' => esc_html__('Projects Completed', 'dhaara-addon'),
                    ],
                    [
                        'stat_number' => '24',
                        'stat_suffix' => '/7',
                        'stat_title' => esc_html__('Support Available', 'dhaara-addon'),
                    ],
                ],
                'title_field' => '{{{ stat_title }}}',
                'condition' => [
                    'show_stats' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Show More Services Control
        $this->start_controls_section(
            'show_more_section',
            [
                'label' => esc_html__('View All Button', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_show_more',
            [
                'label' => esc_html__('Enable Show More', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );



        $this->add_control(
            'show_more_text',
            [
                'label' => esc_html__('Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('View All Services', 'dhaara-addon'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'enable_show_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_more_link',
            [
                'label' => esc_html__('Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'enable_show_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'explore_service_text',
            [
                'label' => esc_html__('Explore Service Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Explore Service', 'dhaara-addon'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Controls
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],

            ]
        );

        $this->end_controls_section();
    }

    private function get_services()
    {
        $services = get_posts([
            'post_type' => 'service',
            'posts_per_page' => -1,
            'post_status' => 'publish',
        ]);

        $options = [];
        foreach ($services as $service) {
            $options[$service->ID] = $service->post_title;
        }
        return $options;
    }

    protected function render_featured_service()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#2563EB';
        $learn_more_text = !empty($settings['learn_more_text']) ? $settings['learn_more_text'] : "Learn More";
        
        if (empty($settings['featured_service'])) {
            return;
        }

        $service = get_post($settings['featured_service']);
        if (!$service) {
            return;
        }

?>
        <div class="relative grid md:grid-cols-2 gap-8 items-center fade-in-effect  ">
            <div class="relative h-64 md:h-full min-h-[300px]">
                <div class="relative h-full rounded-2xl overflow-hidden">
                    <?php if (has_post_thumbnail($service->ID)): ?>
                        <?php echo get_the_post_thumbnail($service->ID, 'full', [
                            'class' => 'absolute inset-0 w-full h-full object-cover'
                        ]); ?>
                    <?php else : ?>
                        <img src="<?php echo \Elementor\Utils::get_placeholder_image_src(); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="absolute inset-0 w-full h-full object-cover">
                    <?php endif; ?>
                </div>

                <div class="absolute -left-6 bottom-8">
                    <div class="bg-white p-6 rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 max-w-xs">

                        <div class="w-14 h-14 rounded-2xl flex items-center justify-center mb-4"
                            style="background-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>">
                            <svg style="color: <?php echo esc_attr($primary_color); ?>" class="w-7 h-7  " fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                        </div>
                        <h4 class="text-xl font-bold text-gray-900 mb-2 aaaa">
                            <?php echo esc_html($settings['floating_card_title']); ?>
                        </h4>
                        <p class="text-gray-600">
                            <?php echo wp_kses_post($settings['floating_card_description']); ?>
                        </p>
                    </div>
                </div>
            </div>
            <div class="relative z-10 bg-white rounded-3xl p-8 shadow-xl h-full group">
                <!-- Service content with dynamic fields -->
                <h3 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">
                    <?php echo wp_kses_post($service->post_title); ?>
                </h3>
                <p class="text-gray-600 mb-8">
                    <?php echo esc_html($service->post_excerpt); ?>
                </p>
                <a href="<?php echo esc_url(get_the_permalink()); ?>"
                    class="inline-flex items-center font-semibold group-hover:translate-x-2 transition-all duration-300"
                    style="color: <?php echo esc_attr($primary_color); ?>">
                    <?php echo esc_html($learn_more_text); ?>
                    <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                    </svg>
                </a>
            </div>
        </div>
        <?php
    }

    protected function render_services_grid()
    {
        $settings = $this->get_settings_for_display();
        $featured_service_id = $settings['featured_service'];
        $services_to_show = $settings['services_to_show'] ? intval($settings['services_to_show']) : 3;
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#2563EB';
        $learn_more_text = !empty($settings['learn_more_text']) ? $settings['learn_more_text'] : "Learn More";
        $counter = 1;
        $services_query = new WP_Query([
            'post_type' => 'service',
            'posts_per_page' => $services_to_show,
            'post_status' => 'publish',
            'post__not_in' => array($featured_service_id),
        ]);
        $post = get_post(get_the_ID());
        if ($services_query->have_posts()): ?>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 lg:gap-8 ">
                <?php while ($services_query->have_posts()):
                    $services_query->the_post();

                ?>
                    <div class="group bg-white rounded-3xl shadow-lg hover:shadow-xl    overflow-hidden fade-in-effect effect-<?php echo esc_attr($counter); ?> ">
                        <?php if (has_post_thumbnail()): ?>
                            <div class="relative aspect-[3/2] overflow-hidden">
                                <?php the_post_thumbnail('service-thumbnail', [
                                    'class' => 'w-full h-full object-cover transition-transform duration-300 group-hover:scale-110'
                                ]); ?>
                                <!-- Gradient Overlay -->
                                <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                            </div>

                        <?php else : ?>
                            <div class="relative aspect-[3/2] overflow-hidden">
                                <img src="<?php echo \Elementor\Utils::get_placeholder_image_src(); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                            </div>
                        <?php endif; ?>

                        <div class="p-6">
                            <h3 class="text-xl font-bold text-gray-900 mb-4 "><?php the_title(); ?></h3>
                            <p class="text-gray-600 mb-6 line-clamp-2"> <?php echo esc_html(get_the_excerpt()); ?></p>

                            <a href="<?php echo esc_url(get_the_permalink()); ?>"
                                class="inline-flex items-center font-semibold group-hover:translate-x-2 transition-all duration-300"
                                style="color: <?php echo esc_attr($primary_color); ?>">
                                <?php echo esc_html($learn_more_text); ?>
                                <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </a>
                        </div>
                    </div>
                <?php
                    $counter++;
                endwhile; ?>
            </div>
        <?php
        endif;
        wp_reset_postdata();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#2563EB';
        $counter = 1;
        ?>
        <section class="service-section relative py-16 sm:py-20 lg:py-20 overflow-hidden z-10" x-data="{ showAll: false }">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">

                <div style="background-color: <?php echo esc_attr($primary_color); ?>20"
                    class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                <div style="background-color: <?php echo esc_attr($primary_color); ?>20"
                    class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
            </div>

            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2  -translate-x-1/2  text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        <?php echo esc_html($settings['background_text']); ?>
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect ">
                        <?php echo esc_html($settings['heading_text']); ?>
                        <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1 ">
                        <?php echo esc_html($settings['section_description']); ?>
                    </p>
                </div>

                <!-- Main Content -->
                <div class="grid gap-6 sm:gap-8">
                    <!-- Featured Service -->
                    <?php $this->render_featured_service(); ?>

                    <!-- Services Grid -->
                    <?php $this->render_services_grid(); ?>
                </div>

                <!-- Stats Section -->
                <?php if ($settings['show_stats'] === 'yes'): ?>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-6 lg:gap-8 mt-8">
                        <?php foreach ($settings['stats_list'] as $stat): ?>
                            <div class="bg-white p-6 rounded-3xl shadow-lg hover:shadow-xl fade-in-effect effect-<?php echo esc_attr($counter); ?>">
                                <div class="text-3xl sm:text-4xl font-bold" style="color: <?php echo esc_attr($primary_color); ?>">
                                    <?php echo esc_html($stat['stat_number']); ?>
                                    <span class="text-xl sm:text-2xl"><?php echo esc_html($stat['stat_suffix']); ?></span>
                                </div>
                                <div class="mt-2 text-sm text-gray-600"><?php echo esc_html($stat['stat_title']); ?></div>
                            </div>
                        <?php
                            $counter++;
                        endforeach; ?>
                    </div>
                <?php endif; ?>

                <!-- View All Button -->
                <?php if ($settings['enable_show_more'] === 'yes'): ?>
                    <div class="text-center mt-12 fade-in-effect ">
                        <a href="<?php echo esc_url($settings['show_more_link']['url']); ?>"
                            style="background-color: <?php echo esc_attr($primary_color); ?>"
                            class="group inline-flex items-center gap-2 px-6 sm:px-8 py-3 sm:py-4 text-white font-semibold rounded-lg transition-all duration-300 hover:opacity-90 hover:scale-105 shadow-lg"
                            <?php echo $settings['show_more_link']['is_external'] ? 'target="_blank"' : ''; ?>
                            <?php echo $settings['show_more_link']['nofollow'] ? 'rel="nofollow"' : ''; ?>>
                            <?php echo esc_html($settings['show_more_text']); ?>
                            <svg class="w-5 h-5 transform group-hover:translate-x-2 transition-transform"
                                fill="none"
                                stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M17 8l4 4m0 0l-4 4m4-4H3">
                                </path>
                            </svg>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </section>
<?php
    }
}
