/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 */

( function( $ ) {
    "use strict";

    // Company Information
    wp.customize( 'company_name', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-company-name' ).text( newval );
        } );
    } );

    wp.customize( 'company_description', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-company-description' ).text( newval );
        } );
    } );

    // Contact Information
    wp.customize( 'contact_email', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-contact-email' ).text( newval );
            $( '.footer-email-link' ).attr( 'href', 'mailto:' + newval );
        } );
    } );

    wp.customize( 'contact_phone', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-contact-phone' ).text( newval );
            $( '.footer-phone-link' ).attr( 'href', 'tel:' + newval.replace(/[^0-9+]/g, '') );
        } );
    } );

    // Social Media
    wp.customize( 'social_twitter', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-twitter-link' ).attr( 'href', newval );
        } );
    } );

    wp.customize( 'social_instagram', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-instagram-link' ).attr( 'href', newval );
        } );
    } );

    // Newsletter
    wp.customize( 'newsletter_title', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-newsletter-title' ).text( newval );
        } );
    } );

    wp.customize( 'newsletter_description', function( value ) {
        value.bind( function( newval ) {
            $( '.footer-newsletter-description' ).text( newval );
        } );
    } );

} )( jQuery );

jQuery(document).ready(function($) {
    "use strict";
    
    function initIconPicker(element) {
        $(element).iconpicker({
            placement: 'bottom',
            hideOnSelect: true, // This will close the picker after selection
            templates: {
                search: '<input type="search" class="form-control iconpicker-search" placeholder="Search icons" />'
            }
        }).on('iconpickerSelected', function(event) {
            // Update the value and trigger change for the customizer
            updateSocialMediaValue($(this).closest('.social-media-links-container'));
        });
    }

    function updateSocialMediaValue(container) {
        var items = [];
        container.find('.social-media-item').each(function() {
            items.push({
                platform: $(this).find('.platform').val(),
                icon: $(this).find('.icon-picker').val(),
                url: $(this).find('.url').val()
            });
        });
        container.find('input[type="hidden"]').val(JSON.stringify(items)).trigger('change');
    }

    function createSocialMediaItem(container, data) {
        var data = data || {};
        var index = container.find('.social-media-item').length;
        var template = `
            <div class="social-media-item" data-index="${index}">
                <input type="text" class="platform" value="${data.platform || ''}" placeholder="Platform Name" />
                <input type="text" class="icon-picker" value="${data.icon || ''}" placeholder="Select Icon" />
                <input type="url" class="url" value="${data.url || ''}" placeholder="URL" />
                <button class="remove-social-media" type="button">Remove</button>
            </div>
        `;
        container.find('.social-media-links-list').append(template);
        
        var newItem = container.find('.social-media-item').last();
        initIconPicker(newItem.find('.icon-picker'));
        
        return newItem;
    }

    // Initialize existing items
    $('.social-media-links-container').each(function() {
        var container = $(this);
        container.find('.icon-picker').each(function() {
            initIconPicker(this);
        });

        // Add new social media
        container.on('click', '.add-social-media', function() {
            var newItem = createSocialMediaItem(container);
            updateSocialMediaValue(container);
        });

        // Remove social media
        container.on('click', '.remove-social-media', function() {
            $(this).closest('.social-media-item').remove();
            updateSocialMediaValue(container);
        });

        // Update on change
        container.on('change', '.platform, .icon-picker, .url', function() {
            updateSocialMediaValue(container);
        });
    });
});
