<?php

/**
 * Register Custom Post Type and Taxonomies for Projects
 */

// Register Custom Post Type
function register_project_post_type()
{
    $labels = array(
        'name'                  => _x('Projects', 'Post Type General Name', 'dhaara-addon'),
        'singular_name'         => _x('Project', 'Post Type Singular Name', 'dhaara-addon'),
        'menu_name'            => __('Projects', 'dhaara-addon'),
        'add_new'              => __('Add New Project', 'dhaara-addon'),
        'add_new_item'         => __('Add New Project', 'dhaara-addon'),
        'edit_item'            => __('Edit Project', 'dhaara-addon'),
        'view_item'            => __('View Project', 'dhaara-addon'),
        'all_items'            => __('All Projects', 'dhaara-addon'),
        'search_items'         => __('Search Projects', 'dhaara-addon'),
    );

    $args = array(
        'labels'              => $labels,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_rest'        => true,
        'menu_icon'           => 'dashicons-building',
        'supports'            => array('title', 'editor', 'thumbnail', 'excerpt'),
        'has_archive'         => true,
        'rewrite'            => array('slug' => 'projects'),
        'menu_position'      => 5,
    );

    register_post_type('project', $args);
}
add_action('init', 'register_project_post_type');

// Register Project Category Taxonomy
function register_project_taxonomies()
{
    // Main Project Category
    $category_labels = array(
        'name'              => _x('Project Categories', 'taxonomy general name', 'dhaara-addon'),
        'singular_name'     => _x('Project Category', 'taxonomy singular name', 'dhaara-addon'),
        'menu_name'         => __('Categories', 'dhaara-addon'),
    );

    register_taxonomy('project_category', 'project', array(
        'hierarchical'      => true,
        'labels'            => $category_labels,
        'show_ui'          => true,
        'show_admin_column' => true,
        'show_in_rest'     => true,
        'rewrite'          => array('slug' => 'project-category'),
    ));

    // Project Tags
    $tag_labels = array(
        'name'              => _x('Project Tags', 'taxonomy general name', 'dhaara-addon'),
        'singular_name'     => _x('Project Tag', 'taxonomy singular name', 'dhaara-addon'),
        'menu_name'         => __('Tags', 'dhaara-addon'),
    );

    register_taxonomy('project_tag', 'project', array(
        'hierarchical'      => false,
        'labels'            => $tag_labels,
        'show_ui'          => true,
        'show_admin_column' => true,
        'show_in_rest'     => true,
        'rewrite'          => array('slug' => 'project-tag'),
    ));

    // Project Status Taxonomy
    $status_labels = array(
        'name'              => _x('Project Status', 'taxonomy general name', 'dhaara-addon'),
        'singular_name'     => _x('Project Status', 'taxonomy singular name', 'dhaara-addon'),
        'menu_name'         => __('Status', 'dhaara-addon'),
        'add_new_item'      => __('Add New Status', 'dhaara-addon'),
        'edit_item'         => __('Edit Status', 'dhaara-addon'),
    );

    register_taxonomy('project_status', 'project', array(
        'hierarchical'      => true,
        'labels'            => $status_labels,
        'show_ui'          => true,
        'show_admin_column' => true,
        'show_in_rest'     => true,
        'rewrite'          => array('slug' => 'project-status'),
    ));
}
add_action('init', 'register_project_taxonomies');
