<?php
/* 
Plugin Name: Dhaara Addon
Plugin URI: https://themeforest.net/user/colorbeethemes
Description: Addons for Dhaara WordPress Themes
Version: 1.0
Author: colorbeethemes
Author URI: https://themeforest.net/user/colorbeethemes
Text Domain: dhaara-addon
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * ============================================================================
 * Define Constants
 * ============================================================================
 */
define('DHAARA_ADDON_URL', plugin_dir_url(__FILE__));
define('DHAARA_ADDON_PATH', plugin_dir_path(__FILE__));
/**
 * Include all files
 */
include_once(plugin_dir_path(__FILE__) . 'include/class-ocdi-importer.php');

final class Construction_Elementor_Widgets
{

    const VERSION = '1.0.0';
    const MINIMUM_ELEMENTOR_VERSION = '3.0.0';
    const MINIMUM_PHP_VERSION = '7.3';

    private static $_instance = null;

    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct()
    {
        add_action('init', [$this, 'i18n']);
        add_action('plugins_loaded', [$this, 'init']);
    }

    public function i18n()
    {
        load_plugin_textdomain('construction-widgets');
    }

    public function init()
    {
        // Check if Elementor installed and activated
        if (!did_action('elementor/loaded')) {
            add_action('admin_notices', [$this, 'admin_notice_missing_elementor']);
            return;
        }

        // Check for required Elementor version
        if (!version_compare(ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=')) {
            add_action('admin_notices', [$this, 'admin_notice_minimum_elementor_version']);
            return;
        }

        // Check for required PHP version
        if (version_compare(PHP_VERSION, self::MINIMUM_PHP_VERSION, '<')) {
            add_action('admin_notices', [$this, 'admin_notice_minimum_php_version']);
            return;
        }

        // Add Plugin actions
        add_action('elementor/widgets/register', [$this, 'init_widgets']);
        add_action('elementor/elements/categories_registered', [$this, 'add_elementor_widget_categories']);
    }

    public function init_widgets($widgets_manager)
    {
        // Include Widget files
        require_once(__DIR__ . '/widgets/hero-varient-1.php');
        require_once(__DIR__ . '/widgets/hero-varient-2.php');
        require_once(__DIR__ . '/widgets/hero-varient-3.php');
        require_once(__DIR__ . '/widgets/about-section.php');
        require_once(__DIR__ . '/widgets/project-section.php');
        require_once(__DIR__ . '/widgets/services-section.php');
        require_once(__DIR__ . '/widgets/blog-section.php');
        require_once(__DIR__ . '/widgets/team-section.php');
        require_once(__DIR__ . '/widgets/testimonials-section.php');
        require_once(__DIR__ . '/widgets/client-section.php');
        require_once(__DIR__ . '/widgets/contact-section.php');
        require_once(__DIR__ . '/widgets/project-list-section.php');
        require_once(__DIR__ . '/widgets/service-grid-section.php');
        require_once(__DIR__ . '/widgets/blog-listing.php');
        require_once(__DIR__ . '/widgets/project-details.php');
        require_once(__DIR__ . '/widgets/gallery.php');
        require_once(__DIR__ . '/widgets/service-boxes.php');
        require_once(__DIR__ . '/widgets/faq.php');
        require_once(__DIR__ . '/widgets/cta.php');
        require_once(__DIR__ . '/widgets/stats.php');
        require_once(__DIR__ . '/widgets/project-description.php');

        // Register widget
        $widgets_manager->register(new \Hero_Varient_1_Widget());
        $widgets_manager->register(new \Hero_Varient_2_Widget());
        $widgets_manager->register(new \Hero_Varient_3_Widget());
        $widgets_manager->register(new \About_Section_Widget());
        $widgets_manager->register(new \Projects_Grid_Widget());
        $widgets_manager->register(new \Services_Section_Widget());
        $widgets_manager->register(new \Blog_Posts_Display_Widget());
        $widgets_manager->register(new \Team_Section_Widget());
        $widgets_manager->register(new \Testimonials_Widget());
        $widgets_manager->register(new \Client_Logo_Slider_Widget());
        $widgets_manager->register(new \Contact_Section_Widget());
        $widgets_manager->register(new \Projects_List_Widget());
        $widgets_manager->register(new \Services_Grid_Widget());
        $widgets_manager->register(new \Blog_Listing());
        $widgets_manager->register(new \Project_Details());
        $widgets_manager->register(new \Gallery());
        $widgets_manager->register(new \Service_Boxes());
        $widgets_manager->register(new \FAQ());
        $widgets_manager->register(new \CTA());
        $widgets_manager->register(new \Stats());
        $widgets_manager->register(new \Project_Description());
    }

    public function add_elementor_widget_categories($elements_manager)
    {
        $elements_manager->add_category(
            'dhaara',
            [
                'title' => esc_html__('Dhaara', 'dhaara-addon'),
                'icon' => 'fas fa-building',
            ]
        );
    }

    public function admin_notice_missing_elementor()
    {
        if (isset($_GET['activate'])) unset($_GET['activate']);

        $message = sprintf(
            esc_html__('"%1$s" requires "%2$s" to be installed and activated.', 'construction-widgets'),
            '<strong>' . esc_html__('Construction Widgets', 'construction-widgets') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'construction-widgets') . '</strong>'
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function admin_notice_minimum_elementor_version()
    {
        $message = sprintf(
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'construction-widgets'),
            '<strong>' . esc_html__('Construction Widgets', 'construction-widgets') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'construction-widgets') . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function admin_notice_minimum_php_version()
    {
        $message = sprintf(
            esc_html__('"%1$s" requires PHP version %2$s or greater.', 'construction-widgets'),
            '<strong>' . esc_html__('Construction Widgets', 'construction-widgets') . '</strong>',
            self::MINIMUM_PHP_VERSION
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }
}
//CPT
include(plugin_dir_path(__FILE__) . 'cpt/project-post-type.php');
include(plugin_dir_path(__FILE__) . 'cpt/service-post-type.php');

//Elementor settings
function add_elementor_header_controls()
{
    add_action('elementor/documents/register_controls', function ($document) {
        if (!$document instanceof \Elementor\Core\DocumentTypes\PageBase) {
            return;
        }

        $document->start_controls_section(
            'header_settings',
            [
                'label' => __('Header Settings', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
            ]
        );

        $document->add_control(
            'page_description',
            [
                'label' => __('Page Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => '',
            ]
        );

        $document->add_control(
            'show_stats',
            [
                'label' => __('Show Stats', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        for ($i = 1; $i <= 3; $i++) {
            $document->add_control(
                "stat_icon_{$i}",
                [
                    'label' => __("Icon {$i}", 'dhaara-addon'),
                    'type' => \Elementor\Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'show_stats' => 'yes',
                    ],
                ]
            );
            $document->add_control(
                "stat_number_{$i}",
                [
                    'label' => __("Number {$i}", 'dhaara-addon'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => '',
                    'condition' => [
                        'show_stats' => 'yes',
                    ],
                ]
            );
            $document->add_control(

                "stat_label_{$i}",
                [
                    'label' => __("Label {$i}", 'dhaara-addon'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => '',
                    'condition' => [
                        'show_stats' => 'yes',
                    ],
                ]


            );
        }


        $document->end_controls_section();

        // Register Custom Controls in Elementor Editor for Project Post Type
        if ('project' !== get_post_type()) {
            return;
        }

        $document->start_controls_section(
            'project_meta_section',
            [
                'label' => __('Project Details', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
            ]
        );

        // Completion Date
        $document->add_control(
            'project_completion_date',
            [
                'label' => __('Completion Date', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::DATE_TIME,

            ]
        );

        // Project Progress
        $document->add_control(
            'project_progress',
            [
                'label' => __('Project Progress (%)', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 0,
            ]
        );

        // Project Location
        $document->add_control(
            'project_location',
            [
                'label' => __('Project Location', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $document->end_controls_section();
    });
}
add_action('after_setup_theme', 'add_elementor_header_controls');

function adjust_color_brightness($hex_color, $brightness_percent, $opacity = 1)
{
    // Remove # if present
    $hex_color = ltrim($hex_color, '#');

    // Convert hex to rgb
    $r = hexdec(substr($hex_color, 0, 2));
    $g = hexdec(substr($hex_color, 2, 2));
    $b = hexdec(substr($hex_color, 4, 2));

    // Adjust brightness
    $r = min(255, $r + ($brightness_percent / 100 * 255));
    $g = min(255, $g + ($brightness_percent / 100 * 255));
    $b = min(255, $b + ($brightness_percent / 100 * 255));

    // Convert back to rgb with opacity
    return "rgba($r, $g, $b, $opacity)";
}
// Initialize the plugin
Construction_Elementor_Widgets::instance();

/**
 * Set Elementor System Colors
 */
function set_elementor_system_colors()
{
    // Check if Elementor is active
    if (!did_action('elementor/loaded')) {
        return;
    }

    // Get the active kit ID
    $kit_id = get_option('elementor_active_kit');

    if (!$kit_id) {
        return;
    }

    // Get existing meta
    $meta_key = '_elementor_page_settings';
    $existing_meta = get_post_meta($kit_id, $meta_key, true);

    // Prepare the new system colors
    $system_colors = [
        [
            '_id' => 'primary',
            'title' => esc_html__('Primary', 'dhaara-addon'),
            'color' => '#FFB600'
        ],
    ];

    // If existing meta exists, merge with new colors, otherwise create new array
    if (is_array($existing_meta)) {
        $existing_meta['system_colors'] = $system_colors;
        $updated_meta = $existing_meta;
    } else {
        $updated_meta = ['system_colors' => $system_colors];
    }

    // Update the meta directly
    update_post_meta($kit_id, $meta_key, $updated_meta);
}

// Only run on plugin activation
register_activation_hook(__FILE__, 'set_elementor_system_colors');




/**
 * ============================================================================
 * Enqueue scripts and styles.
 * ===========================================================================
 */
 
function dhaara_plugin_override_theme_assets() {
    // Only run if Elementor is active
    if (did_action('elementor/loaded')) {
        // Remove the theme's 'main-css' if already enqueued
        wp_dequeue_style('main-css');
        wp_deregister_style('main-css');

        // Enqueue plugin's version of main.css
        wp_enqueue_style(
            'main-css',
            DHAARA_ADDON_URL . 'assets/css/main.css',
            ['elementor-frontend'],
            '1.0.0'
        );
    }

     wp_enqueue_script(
        'theme-js-addon',
        DHAARA_ADDON_URL . 'assets/js/theme.js',
        array('jquery'),
        '1.0.0', // or a manually defined version
        true
    );
}
add_action('wp_enqueue_scripts', 'dhaara_plugin_override_theme_assets', 20);

 