<?php

/**
 * About Widget
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class About_Section_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'about_section';
    }

    public function get_title()
    {
        return esc_html__('About Section', 'dhaara-addon');
    }

    public function get_icon()
    {
        return 'eicon-columns';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        // Header Section
        $this->start_controls_section(
            'header_section',
            [
                'label' => esc_html__('Header', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'ABOUT',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Our Creative', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Approach', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => __('Section Description', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('We\'re not just builders – we\'re innovators, dreamers, and problem-solvers pushing the boundaries of architectural possibilities.', 'textdomain'),
            ]
        );
        $this->end_controls_section();

        // Features Section
        $this->start_controls_section(
            'features_section',
            [
                'label' => esc_html__('Features List', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Feature Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Feature Title', 'dhaara-addon'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__('Feature Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Feature description goes here. Explain the benefits and value proposition.', 'dhaara-addon'),
                'label_block' => true,
            ]
        );



        $this->add_control(
            'feature_list',
            [
                'label' => esc_html__('Features', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('Sustainable Design', 'dhaara-addon'),
                        'description' => esc_html__('Our projects prioritize environmental sustainability through innovative design solutions and eco-friendly materials.', 'dhaara-addon'),
                    ],
                    [
                        'title' => esc_html__('Expert Team', 'dhaara-addon'),
                        'description' => esc_html__('Our team of certified architects and designers brings decades of combined experience to every project.', 'dhaara-addon'),
                    ],
                    [
                        'title' => esc_html__('Modern Technology', 'dhaara-addon'),
                        'description' => esc_html__('We utilize cutting-edge 3D modeling and visualization tools to bring your vision to life with precision.', 'dhaara-addon'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );
        $this->end_controls_section();
        // Stats Section
        $this->start_controls_section(
            'stats_section',
            [
                'label' => esc_html__('Statistics', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'years_number',
            [
                'label' => esc_html__('Years Number', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 25,
            ]
        );

        $this->add_control(
            'years_text',
            [
                'label' => esc_html__('Years Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Years of Innovation', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'projects_number',
            [
                'label' => esc_html__('Projects Number', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 500,
            ]
        );

        $this->add_control(
            'projects_text',
            [
                'label' => esc_html__('Projects Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Projects Completed', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Excellence Box Section
        $this->start_controls_section(
            'excellence_section',
            [
                'label' => esc_html__('Excellence Box', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'excellence_title',
            [
                'label' => esc_html__('Excellence Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Excellence Recognized', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'excellence_icon',
            [
                'label' => esc_html__('Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $this->add_control(
            'excellence_description',
            [
                'label' => esc_html__('Excellence Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Multiple international awards for architectural innovation', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Images Section
        $this->start_controls_section(
            'images_section',
            [
                'label' => esc_html__('Images', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'main_image',
            [
                'label' => esc_html__('Main Image', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'main_image_title',
            [
                'label' => esc_html__('Main Image Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('The Horizon Project', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'main_image_subtitle',
            [
                'label' => esc_html__('Main Image Subtitle', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Award-winning sustainable design', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'detail_image',
            [
                'label' => esc_html__('Detail Image', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'detail_image_title',
            [
                'label' => esc_html__('Main Image Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Eco Residences', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'detail_image_subtitle',
            [
                'label' => esc_html__('Main Image Subtitle', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Modern sustainable living spaces', 'dhaara-addon'),
            ]
        );



        $this->add_control(
            'interior_image',
            [
                'label' => esc_html__('Interior Image', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'interior_image_title',
            [
                'label' => esc_html__('Main Image Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('The Azure Tower', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'interior_image_subtitle',
            [
                'label' => esc_html__('Main Image Subtitle', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('A 50-story sustainable skyscraper', 'dhaara-addon'),
            ]
        );
        $this->end_controls_section();

        // Style Sections...
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';

?>

        <section class="about-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="container max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        <?php echo esc_html($settings['background_text']); ?>
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect ">
                        <?php echo esc_html($settings['heading_text']); ?>
                        <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1 ">
                        <?php echo esc_html($settings['section_description']); ?>
                    </p>
                </div>

                <!-- Main Grid - Updated gap classes -->
                <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 sm:gap-8">
                    <!-- Left Column -->
                    <div class="grid lg:col-span-5 gap-6 sm:gap-8">

                        <!-- Feature List -->
                        <div class="flex flex-col gap-6 sm:gap-8">
                            <?php
                            $counter = 1;
                            foreach ($settings['feature_list'] as $feature) : ?>
                                <div class="relative p-4 sm:p-6 bg-white rounded-2xl shadow-lg hover:shadow-xl fade-in-effect effect-<?php echo esc_attr($counter); ?> ">
                                    <span style="background-color: <?php echo esc_attr($primary_color); ?>" class="absolute -left-2 sm:-left-4 -top-2 sm:-top-4 w-6 h-6 sm:w-8 sm:h-8 text-white flex items-center justify-center rounded-lg text-sm sm:text-base"><?php echo esc_html($counter++); ?></span>
                                    <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-2"><?php echo esc_html($feature['title']); ?></h3>
                                    <p class="text-sm sm:text-base text-gray-600"><?php echo esc_html($feature['description']); ?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <!-- Stats Grid - Updated gap classes -->
                        <div class="grid grid-cols-2 gap-6 sm:gap-8 py-6 sm:py-0">
                            <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-lg hover:shadow-xl fade-in-effect ">
                                <div style="color: <?php echo esc_attr($primary_color); ?>" class="text-3xl sm:text-4xl font-bold mb-2"><?php echo esc_html($settings['years_number']); ?><span class="text-2xl sm:text-3xl">+</span></div>
                                <div class="text-sm sm:text-base text-gray-600"><?php echo esc_html($settings['years_text']); ?></div>
                            </div>
                            <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-lg hover:shadow-xl fade-in-effect effect-1 ">
                                <div style="color: <?php echo esc_attr($primary_color); ?>" class="text-3xl sm:text-4xl font-bold mb-2"><?php echo esc_html($settings['projects_number']); ?><span class="text-2xl sm:text-3xl">+</span></div>
                                <div class="text-sm sm:text-base text-gray-600"><?php echo esc_html($settings['projects_text']); ?></div>
                            </div>
                        </div>

                    </div>

                    <!-- Right Column - Updated spacing from space-x to gap -->
                    <div class="lg:col-span-7 mt-8 lg:mt-0">
                        <div class="grid grid-cols-12 h-full gap-6 sm:gap-8">
                            <!-- Left Images -->
                            <div class="col-span-12 sm:col-span-5 h-full flex flex-col gap-6 sm:gap-8">
                                <?php
                                $image_id = $settings['detail_image']['id'];
                                $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                                $image_post = get_post($image_id);
                                $image_title = $image_post ? $image_post->post_title : '';

                                // Fallback if metadata is empty
                                $image_alt = !empty($image_alt) ? $image_alt : esc_attr($settings['detail_image_title']);
                                $image_title = !empty($image_title) ? $image_title : esc_attr($settings['detail_image_title']);
                                ?>
                                <!-- Two Square Images - Updated with overflow-hidden and scale-105 -->
                                <div class="relative group flex-1 fade-in-effect rounded-2xl overflow-hidden">
                                    <img src="<?php echo esc_url($settings['detail_image']['url']); ?>"
                                        alt="<?php echo esc_attr($image_alt); ?>"
                                        title="<?php echo esc_attr($image_title); ?>"
                                        class="md:absolute w-full md:!h-full !h-64 object-cover transform transition-transform duration-300 group-hover:scale-105" />
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                        <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                            <h4 class="text-lg sm:text-xl font-bold text-white"><?php echo esc_html($settings['detail_image_title']); ?></h4>
                                            <p class="text-sm sm:text-base text-white/80 mt-0"><?php echo esc_html($settings['detail_image_subtitle']); ?></p>
                                        </div>
                                    </div>

                                </div>
                                <?php
                                $image_id = $settings['interior_image']['id'];
                                $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                                $image_post = get_post($image_id);
                                $image_title = $image_post ? $image_post->post_title : '';

                                // Fallback if metadata is empty
                                $image_alt = !empty($image_alt) ? $image_alt : esc_attr($settings['interior_image_title']);
                                $image_title = !empty($image_title) ? $image_title : esc_attr($settings['interior_image_title']);
                                ?>
                                <div class="relative group flex-1 fade-in-effect effect-1 rounded-2xl overflow-hidden">
                                    <img src="<?php echo esc_url($settings['interior_image']['url']); ?>"
                                        alt="<?php echo esc_attr($image_alt); ?>"
                                        title="<?php echo esc_attr($image_title); ?>"
                                        class="md:absolute w-full md:!h-full !h-64 object-cover transform transition-transform duration-300 group-hover:scale-105" />
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                        <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                            <h4 class="text-lg sm:text-xl font-bold text-white"><?php echo esc_html($settings['interior_image_title']); ?></h4>
                                            <p class="text-sm sm:text-base text-white/80 mt-0"><?php echo esc_html($settings['interior_image_subtitle']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <!-- Right Side Content -->
                            <div class="col-span-12 sm:col-span-7 h-full flex flex-col gap-6 sm:gap-8">
                                <!-- Excellence Box -->
                                <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-xl hover:shadow-2xl transition-all hover:-translate-y-1 fade-in-effect effect-2 ">
                                    <div style="background-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>" class="w-10 h-10 sm:w-12 sm:h-12 rounded-xl flex items-center justify-center mb-4">
                                        <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($settings['excellence_icon']['value']); ?>"></i>
                                    </div>
                                    <h4 class="text-base sm:text-lg font-bold text-gray-900 mb-2"><?php echo esc_html($settings['excellence_title']); ?></h4>
                                    <p class="text-xs sm:text-sm text-gray-600"><?php echo esc_html($settings['excellence_description']); ?></p>
                                </div>
                                <?php
                                $image_id = $settings['main_image']['id'];
                                $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                                $image_post = get_post($image_id);
                                $image_title = $image_post ? $image_post->post_title : '';

                                // Fallback if metadata is empty
                                $image_alt = !empty($image_alt) ? $image_alt : esc_attr($settings['main_image_title']);
                                $image_title = !empty($image_title) ? $image_title : esc_attr($settings['main_image_title']);
                                ?>
                                <div class="relative group flex-1 fade-in-effect effect-3 overflow-hidden rounded-2xl">
                                    <img src="<?php echo esc_url($settings['main_image']['url']); ?>"
                                        alt="<?php echo esc_attr($image_alt); ?>"
                                        title="<?php echo esc_attr($image_title); ?>"
                                        class="w-full min-h-80 md:!h-full !h-64 sm:!h-[600px] object-cover transform transition-transform duration-300 group-hover:scale-105 lg:absolute" />
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                        <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                            <h4 class="text-lg sm:text-xl font-bold text-white"><?php echo esc_html($settings['main_image_title']); ?></h4>
                                            <p class="text-sm sm:text-base text-white/80 mt-0"><?php echo esc_html($settings['main_image_subtitle']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }
    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#FFB600' ;
            #>
            <section class="about-section relative py-16 sm:py-24 lg:py-24 overflow-hidden">
                <!-- Background Elements -->
                <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                        <div style="background-color: {{ primaryColor }}30" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="container max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
                    <!-- Section Header -->
                    <div class="relative mb-12 sm:mb-16 text-center z-10">
                        <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                            {{{ settings.background_text }}}
                        </div>
                        <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900  ">
                            {{{ settings.heading_text }}}
                            <span style="color: {{ primaryColor }}">{{{ settings.heading_span }}}</span>
                        </h2>
                        <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto   ">
                            {{{ settings.section_description }}}
                        </p>
                    </div>

                    <!-- Main Grid - Updated gap classes -->
                    <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 sm:gap-8">
                        <!-- Left Column -->
                        <div class="grid lg:col-span-5 gap-6 sm:gap-8">
                            <!-- Feature List -->
                            <div class="flex flex-col gap-6 sm:gap-8">
                                <# _.each(settings.feature_list, function(feature, index) { #>
                                    <div class="relative p-4 sm:p-6 bg-white rounded-2xl shadow-lg hover:shadow-xl ">
                                        <span style="background-color: {{ primaryColor }}" class="absolute -left-2 sm:-left-4 -top-2 sm:-top-4 w-6 h-6 sm:w-8 sm:h-8 text-white flex items-center justify-center rounded-lg text-sm sm:text-base">{{{ index + 1 }}}</span>
                                        <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-2">{{{ feature.title }}}</h3>
                                        <p class="text-sm sm:text-base text-gray-600">{{{ feature.description }}}</p>
                                    </div>
                                    <# }); #>
                            </div>

                            <!-- Stats Grid - Updated gap classes -->
                            <div class="grid grid-cols-2 gap-6 sm:gap-8 py-6 sm:py-0">
                                <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-lg hover:shadow-xl  ">
                                    <div style="color: {{ primaryColor }}" class="text-3xl sm:text-4xl font-bold mb-2">{{{ settings.years_number }}}<span class="text-2xl sm:text-3xl">+</span></div>
                                    <div class="text-sm sm:text-base text-gray-600">{{{ settings.years_text }}}</div>
                                </div>
                                <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-lg hover:shadow-xl   ">
                                    <div style="color: {{ primaryColor }}" class="text-3xl sm:text-4xl font-bold mb-2">{{{ settings.projects_number }}}<span class="text-2xl sm:text-3xl">+</span></div>
                                    <div class="text-sm sm:text-base text-gray-600">{{{ settings.projects_text }}}</div>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column - Updated spacing from space-x to gap -->
                        <div class="lg:col-span-7 mt-8 lg:mt-0">
                            <div class="grid grid-cols-12 h-full gap-6 sm:gap-8">
                                <!-- Left Images -->
                                <div class="col-span-12 sm:col-span-5 h-full flex flex-col gap-6 sm:gap-8">
                                    <!-- Two Square Images - Updated with overflow-hidden and scale-105 -->
                                    <div class="relative group flex-1  rounded-2xl overflow-hidden">
                                        <img src="{{ settings.detail_image.url }}"
                                            alt="{{ settings.detail_image_title }}"
                                            title="{{ settings.detail_image_title }}"
                                            class="md:absolute w-full md:!h-full !h-64 object-cover transform transition-transform duration-300 group-hover:scale-105" />
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                            <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                                <h4 class="text-lg sm:text-xl font-bold text-white">{{{ settings.detail_image_title }}}</h4>
                                                <p class="text-sm sm:text-base text-white/80 mt-0">{{{ settings.detail_image_subtitle }}}</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="relative group flex-1   rounded-2xl overflow-hidden">
                                        <img src="{{ settings.interior_image.url }}"
                                            alt="{{ settings.interior_image_title }}"
                                            title="{{ settings.interior_image_title }}"
                                            class="md:absolute w-full md:!h-full !h-64 object-cover transform transition-transform duration-300 group-hover:scale-105" />
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                            <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                                <h4 class="text-lg sm:text-xl font-bold text-white">{{{ settings.interior_image_title }}}</h4>
                                                <p class="text-sm sm:text-base text-white/80 mt-0">{{{ settings.interior_image_subtitle }}}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Right Side Content -->
                                <div class="col-span-12 sm:col-span-7 h-full flex flex-col gap-6 sm:gap-8">
                                    <!-- Excellence Box -->
                                    <div class="bg-white p-4 sm:p-6 rounded-2xl shadow-xl hover:shadow-2xl transition-all hover:-translate-y-1   ">
                                        <div style="background-color: {{ primaryColor }}10" class="w-10 h-10 sm:w-12 sm:h-12 rounded-xl flex items-center justify-center mb-4">
                                            <# if (settings.excellence_icon && settings.excellence_icon.value) { #>
                                                <i style="color: {{ primaryColor }}" class="{{{ settings.excellence_icon.value }}}"></i>
                                                <# } #>
                                        </div>
                                        <h4 class="text-base sm:text-lg font-bold text-gray-900 mb-2">{{{ settings.excellence_title }}}</h4>
                                        <p class="text-xs sm:text-sm text-gray-600">{{{ settings.excellence_description }}}</p>
                                    </div>

                                    <div class="relative group flex-1 rounded-2xl overflow-hidden">
                                        <img src="{{ settings.main_image.url }}"
                                            alt="{{ settings.main_image_title }}"
                                            title="{{ settings.main_image_title }}"
                                            class="w-full min-h-80 md:!h-full !h-64 sm:!h-[600px] object-cover transform transition-transform duration-300 group-hover:scale-105 lg:absolute" />
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                                            <div class="absolute bottom-4 left-4 right-4 sm:right-8">
                                                <h4 class="text-lg sm:text-xl font-bold text-white">{{{ settings.main_image_title }}}</h4>
                                                <p class="text-sm sm:text-base text-white/80 mt-0">{{{ settings.main_image_subtitle }}}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
    <?php
    }
}
