<?php

/**
 * Contact Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Contact_Section_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'contact_section';
    }

    public function get_title()
    {
        return 'Contact Section';
    }

    public function get_icon()
    {
        return 'eicon-form-horizontal';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    private function get_contact_forms()
    {
        $forms = [];

        if (function_exists('wpcf7')) {
            $wpcf7_forms = get_posts([
                'post_type' => 'wpcf7_contact_form',
                'posts_per_page' => -1,
            ]);

            if (!empty($wpcf7_forms)) {
                foreach ($wpcf7_forms as $form) {
                    $forms[$form->ID] = $form->post_title;
                }
            }
        }

        return $forms;
    }

    protected function register_controls()
    {
        // Header Section
        $this->start_controls_section(
            'header_section',
            [
                'label' => 'Header',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'CONTACT',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Let\'s Start Your', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Project Together', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => 'Description',
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Ready to transform your vision into reality? Reach out to us and let\'s create something extraordinary.',
            ]
        );

        $this->end_controls_section();

        // Form Section
        $this->start_controls_section(
            'form_section',
            [
                'label' => 'Form Settings',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'contact_form_list',
            [
                'label' => esc_html__('Select Contact Form', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $this->get_contact_forms(),
                'description' => esc_html__('Select a Contact Form 7 form', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Contact Information Section
        $this->start_controls_section(
            'contact_info_section',
            [
                'label' => 'Contact Information',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Add new heading controls
        $this->add_control(
            'office_heading',
            [
                'label' => 'Office Location Heading',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Visit Our Office',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        // Add location icon control
        $this->add_control(
            'location_icon',
            [
                'label' => esc_html__('Location Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'eicon-map-pin',
                    'library' => 'eicons',
                ],
            ]
        );

        $this->add_control(
            'contact_heading',
            [
                'label' => 'Contact Methods Heading',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Get in Touch',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        // Add email icon control
        $this->add_control(
            'email_icon',
            [
                'label' => esc_html__('Email Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'eicon-mail',
                    'library' => 'eicons',
                ],
            ]
        );

        $this->add_control(
            'hours_heading',
            [
                'label' => 'Working Hours Heading',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Working Hours',
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        // Add clock icon control
        $this->add_control(
            'clock_icon',
            [
                'label' => esc_html__('Clock Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'eicon-clock-o',
                    'library' => 'eicons',
                ],
            ]
        );

        $this->add_control(
            'office_address',
            [
                'label' => 'Office Address',
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => '123 Design Street, Creative District<br/>New York, NY 10001',
            ]
        );

        $this->add_control(
            'email',
            [
                'label' => 'Email',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'info@dhaara.com',
            ]
        );

        $this->add_control(
            'phone',
            [
                'label' => 'Phone',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '+1 (234) 567-890',
            ]
        );

        $this->add_control(
            'working_hours',
            [
                'label' => 'Working Hours',
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Monday - Friday: 9:00 AM - 6:00 PM<br/>Saturday: 10:00 AM - 4:00 PM',
            ]
        );

        $this->add_control(
            'map_image',
            [
                'label' => 'Map Image',
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => 'Style',
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>
        <section class="contact-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
                </div>
            </div>
            <!-- Section Header -->
            <div class="relative mb-12 sm:mb-16 text-center z-10">
                <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                    <?php echo esc_html($settings['background_text']); ?>
                </div>
                <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect ">
                    <?php echo esc_html($settings['heading_text']); ?>
                    <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1">
                    <?php echo esc_html($settings['section_description']); ?>
                </p>
            </div>
            <!-- Contact Content -->
            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <div class="grid lg:grid-cols-2 gap-16">
                    <!-- Contact Form -->
                    <div class="relative group fade-in-effect effect-1">
                        <div class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                        <div class="relative bg-white rounded-2xl p-8 shadow-xl">
                            <?php
                            if (!empty($settings['contact_form_list'])) {
                                echo do_shortcode('[contact-form-7 id="' . esc_attr($settings['contact_form_list']) . '"]');
                            } else {
                                echo esc_html__('Please select a contact form from the widget settings.', 'dhaara-addon');
                            }
                            ?>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="space-y-8 fade-in-effect effect-2">
                        <!-- Info Cards -->
                        <div class="grid gap-6 sm:gap-8">
                            <!-- Office Location -->
                            <div class="group relative">
                                <div class="absolute -inset-1 rounded-xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                <div class="relative bg-white p-6 rounded-xl shadow-lg">
                                    <div class="flex items-start gap-6">
                                        <div style="background-color: <?php echo esc_attr($primary_color); ?>10" class="w-12 h-12 rounded-lg flex items-center justify-center text-primary-amber">
                                            <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($settings['location_icon']['value']); ?>"></i>
                                        </div>
                                        <div>
                                            <h3 class="text-lg font-semibold text-gray-900 mt-0"><?php echo esc_html($settings['office_heading']); ?></h3>
                                            <p class="text-gray-600"><?php echo $settings['office_address']; ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Contact Methods -->
                            <div class="group relative">
                                <div class="absolute -inset-1 rounded-xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                <div class="relative bg-white p-6 rounded-xl shadow-lg">
                                    <div class="flex items-start gap-6">
                                        <div style="background-color: <?php echo esc_attr($primary_color); ?>10" class="w-12 h-12 rounded-lg flex items-center justify-center text-primary-amber">
                                            <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($settings['email_icon']['value']); ?>"></i>
                                        </div>
                                        <div>
                                            <h3 class="text-lg font-semibold text-gray-900 mt-0"><?php echo esc_html($settings['contact_heading']); ?></h3>
                                            <p class="text-gray-600"><?php echo esc_html($settings['email']); ?><br /><?php echo esc_html($settings['phone']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Working Hours -->
                            <div class="group relative">
                                <div class="absolute -inset-1 rounded-xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                <div class="relative bg-white p-6 rounded-xl shadow-lg">
                                    <div class="flex items-start gap-6">
                                        <div style="background-color: <?php echo esc_attr($primary_color); ?>10" class="w-12 h-12 rounded-lg flex items-center justify-center text-primary-amber">
                                            <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($settings['clock_icon']['value']); ?>"></i>
                                        </div>
                                        <div>
                                            <h3 class="text-lg font-semibold text-gray-900 mt-0"><?php echo esc_html($settings['hours_heading']); ?></h3>
                                            <p class="text-gray-600"><?php echo $settings['working_hours']; ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Map -->
                            <?php if (!empty($settings['map_image']['url'])): ?>
                                <div class="group relative">
                                    <div class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                    <div class="relative bg-white rounded-2xl overflow-hidden shadow-xl">
                                        <img src="<?php echo esc_url($settings['map_image']['url']); ?>" alt="Office Location Map" class="w-full h-64 object-cover" />
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <?php
    }

    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#FFB600' ;
            #>
            <section class="contact-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
                <!-- Background Elements -->
                <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                        <div style="background-color: {{ primaryColor }}30" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
                    </div>
                </div>

                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        {{{ settings.background_text }}}
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 ">
                        {{{ settings.heading_text }}}
                        <span style="color: {{ primaryColor }}">{{{ settings.heading_span }}}</span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto  ">
                        {{{ settings.section_description }}}
                    </p>
                </div>

                <!-- Contact Content -->
                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <div class="grid lg:grid-cols-2 gap-16">
                        <!-- Contact Form -->
                        <div class="relative group  ">
                            <div class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                            <div class="relative bg-white rounded-2xl p-8 shadow-xl">
                                <# if ( settings.contact_form_list ) { #>
                                    <div class="elementor-contact-form-7 elementor-contact-form-{{settings.contact_form_list}}">
                                        <div class="wpcf7">
                                            <div class="wpcf7-form">
                                                <p>Contact Form {{settings.contact_form_list}} will be displayed here.</p>
                                                <p><i>Note: Actual form will be visible on frontend.</i></p>
                                            </div>
                                        </div>
                                    </div>
                                    <# } else { #>
                                        <p>Please select a contact form from the widget settings.</p>
                                        <# } #>
                            </div>
                        </div>

                        <!-- Contact Information -->
                        <div class="space-y-8 ">
                            <div class="grid gap-6 sm:gap-8">
                                <!-- Office Location -->
                                <div class="group relative">
                                    <div class="absolute -inset-1 rounded-xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                    <div class="relative bg-white p-6 rounded-xl shadow-lg">
                                        <div class="flex items-start gap-6">
                                            <div style="background-color: {{ primaryColor }}10" class="w-12 h-12 rounded-lg flex items-center justify-center text-primary-amber">
                                                <i style="color: {{ primaryColor }}" class="{{ settings.location_icon.value }}"></i>
                                            </div>
                                            <div>
                                                <h3 class="text-lg font-semibold text-gray-900 mt-0">{{{ settings.office_heading }}}</h3>
                                                <p class="text-gray-600">{{{ settings.office_address }}}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Contact Methods -->
                                <div class="group relative">
                                    <div class="absolute -inset-1 rounded-xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                    <div class="relative bg-white p-6 rounded-xl shadow-lg">
                                        <div class="flex items-start gap-6">
                                            <div style="background-color: {{ primaryColor }}10" class="w-12 h-12 rounded-lg flex items-center justify-center text-primary-amber">
                                                <i style="color: {{ primaryColor }}" class="{{ settings.email_icon.value }}"></i>
                                            </div>
                                            <div>
                                                <h3 class="text-lg font-semibold text-gray-900 mt-0">{{{ settings.contact_heading }}}</h3>
                                                <p class="text-gray-600">{{{ settings.email }}}<br />{{{ settings.phone }}}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Working Hours -->
                                <div class="group relative">
                                    <div class="absolute -inset-1 rounded-xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                    <div class="relative bg-white p-6 rounded-xl shadow-lg">
                                        <div class="flex items-start gap-6">
                                            <div style="background-color: {{ primaryColor }}10" class="w-12 h-12 rounded-lg flex items-center justify-center text-primary-amber">
                                                <i style="color: {{ primaryColor }}" class="{{ settings.clock_icon.value }}"></i>
                                            </div>
                                            <div>
                                                <h3 class="text-lg font-semibold text-gray-900 mt-0">{{{ settings.hours_heading }}}</h3>
                                                <p class="text-gray-600">{{{ settings.working_hours }}}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Map -->
                                <# if ( settings.map_image.url ) { #>
                                    <div class="group relative">
                                        <div class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                        <div class="relative bg-white rounded-2xl overflow-hidden shadow-xl">
                                            <img src="{{ settings.map_image.url }}" alt="Office Location Map" class="w-full h-64 object-cover" />
                                        </div>
                                    </div>
                                    <# } #>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
    <?php
    }
}
    ?>