<?php

/**
 * Architectural Hero Widget
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Hero_Varient_2_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'hero_varient_2';
    }

    public function get_title()
    {
        return esc_html__('Hero Varient 2', 'dhaara-addon');
    }

    public function get_icon()
    {
        return 'eicon-header';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    public function get_keywords()
    {
        return ['hero', 'architectural', 'building', 'future', '3d'];
    }

    protected function register_controls()
    {
        // Heading Section
        $this->start_controls_section(
            'heading_section',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'heading_text_before',
            [
                'label' => esc_html__('Heading Before', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Building The',
            ]
        );

        $this->add_control(
            'heading_text_highlight',
            [
                'label' => esc_html__('Heading Highlight', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Future',
            ]
        );

        $this->end_controls_section();

        // Description Section
        $this->start_controls_section(
            'description_section',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'description_text',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Transforming visions into architectural masterpieces.',
            ]
        );

        $this->end_controls_section();

        // Stats Section
        $this->start_controls_section(
            'stats_section',
            [
                'label' => esc_html__('Statistics', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'projects_stat',
            [
                'label' => esc_html__('Projects Count', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 500,
            ]
        );

        $this->add_control(
            'projects_label',
            [
                'label' => esc_html__('Projects Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'PROJECTS',
            ]
        );

        $this->add_control(
            'years_stat',
            [
                'label' => esc_html__('Years Count', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 15,
            ]
        );

        $this->add_control(
            'years_label',
            [
                'label' => esc_html__('Years Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'YEARS',
            ]
        );

        $this->add_control(
            'success_stat',
            [
                'label' => esc_html__('Success Rate', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 98,
            ]
        );

        $this->add_control(
            'success_label',
            [
                'label' => esc_html__('Success Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'SUCCESS',
            ]
        );

        $this->end_controls_section();

        // Buttons Section
        $this->start_controls_section(
            'buttons_section',
            [
                'label' => esc_html__('Buttons', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'primary_button_text',
            [
                'label' => esc_html__('Primary Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Explore Projects →',
            ]
        );

        $this->add_control(
            'primary_button_link',
            [
                'label' => esc_html__('Primary Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'secondary_button_text',
            [
                'label' => esc_html__('Secondary Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Watch Story',
            ]
        );

        $this->add_control(
            'secondary_button_link',
            [
                'label' => esc_html__('Secondary Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Cube Section
        $this->start_controls_section(
            'cube_section',
            [
                'label' => esc_html__('3D Cube', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'cube_face_1',
            [
                'label' => esc_html__('Cube Face 1', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'DESIGN',
            ]
        );

        $this->add_control(
            'cube_face_2',
            [
                'label' => esc_html__('Cube Face 2', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'BUILD',
            ]
        );

        $this->add_control(
            'cube_face_3',
            [
                'label' => esc_html__('Cube Face 3', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'INNOVATE',
            ]
        );

        $this->add_control(
            'cube_face_4',
            [
                'label' => esc_html__('Cube Face 4', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'DELIVER',
            ]
        );

        $this->add_control(
            'cube_face_5',
            [
                'label' => esc_html__('Cube Face 5', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'QUALITY',
            ]
        );

        $this->add_control(
            'cube_face_6',
            [
                'label' => esc_html__('Cube Face 6', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'FUTURE',
            ]
        );

        $this->end_controls_section();

        // Award Section
        $this->start_controls_section(
            'award_section',
            [
                'label' => esc_html__('Award Badge', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'award_title',
            [
                'label' => esc_html__('Award Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Award Winner 2025',
            ]
        );

        $this->add_control(
            'award_description',
            [
                'label' => esc_html__('Award Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Best Architectural Innovation',
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Brand Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFB600',
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $brand_color = !empty($settings['brand_color']) ? $settings['brand_color'] : '#FFB600';
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>

        <!-- Hero Section -->
        <section class="hero-scene relative min-h-full 3xl:min-h-full w-full py-16 sm:py-20 lg:py-20 overflow-hiddenn">

            <!-- Enhanced Wireframe Lines -->
            <svg class="absolute inset-0 w-full h-full pointer-events-none opacity-40">
                <defs>
                    <filter id="glow">
                        <feGaussianBlur stdDeviation="3" result="coloredBlur" />
                        <feMerge>
                            <feMergeNode in="coloredBlur" />
                            <feMergeNode in="SourceGraphic" />
                        </feMerge>
                    </filter>
                </defs>
                <line class="wire-line" x1="0" y1="150" x2="300" y2="150" style="stroke:<?php echo esc_attr($primary_color); ?>" />
                <line class="wire-line" x1="500" y1="80" x2="800" y2="200" style="stroke:<?php echo esc_attr($primary_color); ?>" />
                <line class="wire-line" x1="200" y1="300" x2="600" y2="450" style="stroke:<?php echo esc_attr($primary_color); ?>" />
                <line class="wire-line" x1="700" y1="300" x2="1100" y2="400" style="stroke:<?php echo esc_attr($primary_color); ?>" />
                <circle class="wire-line" cx="150" cy="150" r="40" style="stroke:<?php echo esc_attr($primary_color); ?>" />
                <circle class="wire-line" cx="650" cy="200" r="25" style="stroke:<?php echo esc_attr($primary_color); ?>" />
                <circle class="wire-line" cx="400" cy="350" r="35" style="stroke:<?php echo esc_attr($primary_color); ?>" />
            </svg>

            <!-- Floating Elements -->
            <div class="absolute top-20 left-16 floating-element float-1">
                <div class="morphing-blob w-32 h-32" style="background: linear-gradient(45deg, <?php echo esc_attr($primary_color); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 20, 0.8)); ?>, <?php echo esc_attr($primary_color); ?>);"></div>
            </div>

            <div class="absolute top-40 right-20 floating-element float-2">
                <div class="morphing-blob w-24 h-24" style="background: linear-gradient(45deg, <?php echo esc_attr($primary_color); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 20, 0.8)); ?>, <?php echo esc_attr($primary_color); ?>);"></div>
            </div>
            <!-- Main Content -->
            <div class="relative z-40 container max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8 ">
                <div class="mx-auto">
                    <div class="grid lg:grid-cols-2 gap-16 items-start">
                        <!-- Left Content -->
                        <div class="space-y-10">
                            <!-- Main Headline -->
                            <div class="reveal-up reveal-2">
                                <h1 class="text-5xl sm:text-5xl lg:text-6xl font-bold text-gray-900 leading-tight fade-in-effect effect-2 is-visible">
                                    <?php echo esc_html($settings['heading_text_before']); ?>
                                    <br>
                                    <span style="color: <?php echo esc_attr($primary_color); ?>;"><?php echo esc_html($settings['heading_text_highlight']); ?></span>
                                </h1>
                            </div>
                            <!-- Description -->
                            <div class="reveal-up reveal-3">
                                <p class="text-lg text-gray-700 font-medium max-w-lg leading-relaxed">
                                    <?php echo esc_html($settings['description_text']); ?>
                                </p>
                            </div>
                            <!-- Action Buttons -->
                            <div class="reveal-up reveal-4 flex  flex-col md:flex-row gap-6">
                                <a href="<?php echo esc_url($settings['primary_button_link']['url']); ?>"
                                    style="background-color: <?php echo esc_attr($primary_color); ?>; --hover-color: <?php echo esc_attr($primary_color); ?>;"
                                    class="group inline-flex items-center gap-2 px-6 sm:px-8 py-3 sm:py-4 text-white font-semibold rounded-lg transition-all duration-300 hover:scale-105 shadow-lg hover:shadow-xl">
                                    <span class="relative z-10"><?php echo esc_html($settings['primary_button_text']); ?></span>
                                </a>
                                <a href="<?php echo esc_url($settings['secondary_button_link']['url']); ?>" class="bg-white magnetic-button border-2 border-gray-900 text-gray-900 font-bold px-10 py-3 rounded-xl transition-all duration-300 hover:scale-105 shadow-lg hover:shadow-xl">
                                    <span class="relative z-10"><?php echo esc_html($settings['secondary_button_text']); ?></span>
                                </a>
                            </div>

                            <!-- Stats -->
                            <div class="reveal-up reveal-5 grid grid-cols-1 md:grid-cols-3 gap-6 pt-8">
                                <div class="stat-card p-6 rounded-2xl text-center" style="border-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.5)); ?>;background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.02)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.05)); ?>);">
                                    <div class="text-3xl font-black mb-2" style="color: <?php echo esc_attr($primary_color); ?>;"><?php echo esc_html($settings['projects_stat']); ?>+</div>
                                    <p class="text-sm font-semibold text-gray-600"><?php echo esc_html($settings['projects_label']); ?></p>
                                </div>
                                <div class="stat-card p-6 rounded-2xl text-center" style="border-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.5)); ?>;background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.02)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.05)); ?>);">
                                    <div class="text-3xl font-black mb-2" style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['years_stat']); ?></div>
                                    <p class="text-sm font-semibold text-gray-600"><?php echo esc_html($settings['years_label']); ?></p>
                                </div>
                                <div class="stat-card p-6 rounded-2xl text-center" style="border-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.5)); ?>;background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.02)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.05)); ?>);">
                                    <div class="text-3xl font-black mb-2" style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['success_stat']); ?>%</div>
                                    <p class="text-sm font-semibold text-gray-600"><?php echo esc_html($settings['success_label']); ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- Right Content -->
                        <div class="space-y-8 relative flex flex-col justify-center items-center gap-16 mt-20">
                            <!-- 3D Cube centered with lots of space -->
                            <div class="interactive-cube flex justify-center ">
                                <div class="cube">
                                    <div class="cube-face front" style="border-color: <?php echo esc_attr($primary_color); ?>;color: <?php echo esc_attr($primary_color); ?>; background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.1)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>);"><?php echo esc_html($settings['cube_face_1']); ?></div>
                                    <div class="cube-face back" style="border-color: <?php echo esc_attr($primary_color); ?>;color: <?php echo esc_attr($primary_color); ?>;background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.1)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>);"><?php echo esc_html($settings['cube_face_2']); ?></div>
                                    <div class="cube-face right" style="border-color: <?php echo esc_attr($primary_color); ?>;color: <?php echo esc_attr($primary_color); ?>; background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.1)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>);"><?php echo esc_html($settings['cube_face_3']); ?></div>
                                    <div class="cube-face left" style="border-color: <?php echo esc_attr($primary_color); ?>;color: <?php echo esc_attr($primary_color); ?>; background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.1)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>);"><?php echo esc_html($settings['cube_face_4']); ?></div>
                                    <div class="cube-face top" style="border-color: <?php echo esc_attr($primary_color); ?>;color: <?php echo esc_attr($primary_color); ?>; background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.1)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.1)); ?>);"><?php echo esc_html($settings['cube_face_5']); ?></div>
                                    <div class="cube-face bottom" style="border-color: <?php echo esc_attr($primary_color); ?>;color: <?php echo esc_attr($primary_color); ?>; background: linear-gradient(135deg, <?php echo esc_attr(adjust_color_brightness($primary_color, 0, 0.1)); ?>, <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>);"><?php echo esc_html($settings['cube_face_6']); ?></div>
                                </div>
                            </div>

                            <!-- Award Badge -->
                            <div class="glass-card py-6 px-12 rounded-2xl text-center bg-white">
                                <div style="color: <?php echo esc_attr($primary_color); ?>" class="text-2xl mb-2">★ ★ ★</div>
                                <div class="flexv flex-col">
                                    <h4 class="font-bold text-gray-900 mb-1"><?php echo esc_html($settings['award_title']); ?></h4>
                                    <p class="text-sm text-gray-600"><?php echo esc_html($settings['award_description']); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
