<?php

/**
 * Construction Hero Widget
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Hero_Varient_3_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'hero_varient_3';
    }

    public function get_title()
    {
        return esc_html__('Hero Varient 3', 'dhaara-addon');
    }

    public function get_icon()
    {
        return 'eicon-header';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    public function get_keywords()
    {
        return ['hero', 'construction', 'building'];
    }

    protected function register_controls()
    {
        // Badge Section
        $this->start_controls_section(
            'badge_section',
            [
                'label' => esc_html__('Badge', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'badge_text',
            [
                'label' => esc_html__('Badge Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Premium Construction',
            ]
        );

        $this->end_controls_section();

        // Heading Section
        $this->start_controls_section(
            'heading_section',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'heading_text_before',
            [
                'label' => esc_html__('Heading Before', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Building',
            ]
        );

        $this->add_control(
            'heading_text_highlight',
            [
                'label' => esc_html__('Heading Highlight', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Excellence',
            ]
        );

        $this->add_control(
            'heading_text_after',
            [
                'label' => esc_html__('Heading After', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'in Every Detail',
            ]
        );

        $this->end_controls_section();

        // Description Section
        $this->start_controls_section(
            'description_section',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'description_text',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'We combine innovative design with superior craftsmanship to create spaces that inspire. Our commitment to excellence ensures every project exceeds expectations.',
            ]
        );

        $this->end_controls_section();

        // Stats Section
        $this->start_controls_section(
            'stats_section',
            [
                'label' => esc_html__('Statistics', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'years_experience',
            [
                'label' => esc_html__('Years Experience', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 25,
            ]
        );

        $this->add_control(
            'projects_done',
            [
                'label' => esc_html__('Projects Done', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 350,
            ]
        );

        $this->add_control(
            'expert_team',
            [
                'label' => esc_html__('Expert Team', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 120,
            ]
        );

        $this->end_controls_section();

        // Buttons Section
        $this->start_controls_section(
            'buttons_section',
            [
                'label' => esc_html__('Buttons', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'primary_button_text',
            [
                'label' => esc_html__('Primary Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'View Projects',
            ]
        );

        $this->add_control(
            'primary_button_link',
            [
                'label' => esc_html__('Primary Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'secondary_button_text',
            [
                'label' => esc_html__('Secondary Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Contact Us',
            ]
        );

        $this->add_control(
            'secondary_button_link',
            [
                'label' => esc_html__('Secondary Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Image Section
        $this->start_controls_section(
            'image_section',
            [
                'label' => esc_html__('Image', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'hero_image',
            [
                'label' => esc_html__('Hero Image', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'project_title',
            [
                'label' => esc_html__('Project Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'The Horizon Tower',
            ]
        );

        $this->add_control(
            'project_description',
            [
                'label' => esc_html__('Project Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Award-winning architectural design in downtown metropolis',
            ]
        );

        // Stats Labels
        $this->add_control(
            'years_experience_label',
            [
                'label' => esc_html__('Years Experience Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Years Experience',
            ]
        );

        $this->add_control(
            'projects_done_label',
            [
                'label' => esc_html__('Projects Done Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Projects Done',
            ]
        );

        $this->add_control(
            'expert_team_label',
            [
                'label' => esc_html__('Expert Team Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Expert Team',
            ]
        );

        $this->end_controls_section();

        // Floating Cards Section
        $this->start_controls_section(
            'floating_cards_section',
            [
                'label' => esc_html__('Floating Cards', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'quality_card_title',
            [
                'label' => esc_html__('Quality Card Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Quality Assured',
            ]
        );

        $this->add_control(
            'quality_card_description',
            [
                'label' => esc_html__('Quality Card Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Premium materials and expert craftsmanship',
            ]
        );

        $this->add_control(
            'delivery_card_title',
            [
                'label' => esc_html__('Delivery Card Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Fast Delivery',
            ]
        );

        $this->add_control(
            'delivery_card_description',
            [
                'label' => esc_html__('Delivery Card Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'On-time completion guaranteed',
            ]
        );

        $this->end_controls_section();

        // Style Sections...
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>
        <section class="hero-section relative 3xl:min-h-full w-full py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class=" absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="container max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8 ">
                <div class="grid lg:grid-cols-2 gap-12 lg:gap-20 items-start">
                    <!-- Left Column -->
                    <div class="space-y-6 sm:space-y-8">
                        <div style="background-color: <?php echo esc_attr($primary_color); ?>40" class="inline-flex items-center gap-2  px-4 py-2 rounded-full shadow-sm fade-in-effect effect-1">
                            <div style="background-color: <?php echo esc_attr($primary_color); ?>" class="h-2 w-2   rounded-full"></div>
                            <span style="color: <?php echo esc_attr($primary_color); ?>" class="  font-medium text-sm sm:text-base"><?php echo esc_html($settings['badge_text']); ?></span>
                        </div>

                        <h2 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 leading-tight fade-in-effect effect-2">
                            <?php echo esc_html($settings['heading_text_before']); ?>
                            <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_text_highlight']); ?></span>
                            <?php echo esc_html($settings['heading_text_after']); ?>
                        </h2>

                        <p class="text-gray-600 text-base sm:text-lg max-w-xl fade-in-effect effect-3">
                            <?php echo esc_html($settings['description_text']); ?>
                        </p>

                        <!-- Stats - Updated classes -->
                        <div class="grid grid-cols-1 sm:grid-cols-3 py-6 sm:py-8 gap-6 sm:gap-8">
                            <div class="bg-white p-3 sm:p-4 rounded-xl hover:shadow-lg shadow-sm fade-in-effect effect-4">
                                <div class="text-3xl sm:text-4xl font-bold text-gray-900 mb-2 text-center"><?php echo esc_html($settings['years_experience']); ?><span style="color: <?php echo esc_attr($primary_color); ?>">+</span></div>
                                <div class="text-sm sm:text-base text-gray-600 text-center"><?php echo esc_html($settings['years_experience_label']); ?></div>
                            </div>
                            <div class="bg-white p-3 sm:p-4 rounded-xl hover:shadow-lg shadow-sm fade-in-effect effect-5">
                                <div class="text-3xl sm:text-4xl font-bold text-gray-900 mb-2 text-center"><?php echo esc_html($settings['projects_done']); ?><span style="color: <?php echo esc_attr($primary_color); ?>">+</span></div>
                                <div class="text-sm sm:text-base text-gray-600 text-center"><?php echo esc_html($settings['projects_done_label']); ?></div>
                            </div>
                            <div class="bg-white p-3 sm:p-4 rounded-xl hover:shadow-lg shadow-sm fade-in-effect effect-6">
                                <div class="text-3xl sm:text-4xl font-bold text-gray-900 mb-2 text-center"><?php echo esc_html($settings['expert_team']); ?><span style="color: <?php echo esc_attr($primary_color); ?>">+</span></div>
                                <div class="text-sm sm:text-base text-gray-600 text-center"><?php echo esc_html($settings['expert_team_label']); ?></div>
                            </div>
                        </div>

                        <!--  Buttons -->
                        <div class="flex flex-col sm:flex-row gap-6 sm:gap-8">
                            <a href="<?php echo esc_url($settings['primary_button_link']['url']); ?>" style="background-color: <?php echo esc_attr($primary_color); ?>" class="group px-6 sm:px-8 py-3 sm:py-4   text-white font-semibold rounded-lg    hover:scale-105 shadow-lg shadow-amber-200 fade-in-effect effect-1 primary-button text-center">
                                <span class="inline-flex items-center">
                                    <?php echo esc_html($settings['primary_button_text']); ?>
                                    <svg class="w-5 h-5 ml-2 transform group-hover:translate-x-2 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                    </svg>
                                </span>
                            </a>
                            <a href="<?php echo esc_url($settings['secondary_button_link']['url']); ?>" style="--hover-color: <?php echo esc_attr($primary_color); ?>;" class="px-6 sm:px-8 py-3 sm:py-4 border-2 border-gray-200 text-gray-700 font-semibold rounded-lg  bg-white  hover:scale-105 secondary-button fade-in-effect effect-2 text-center">
                                <?php echo esc_html($settings['secondary_button_text']); ?>
                            </a>
                        </div>
                    </div>

                    <!-- Right Column -->
                    <div class="relative mt-8 lg:mt-0 fade-in-effect effect h-full">
                        <!-- Main Image with Overlay -->
                        <div class="relative rounded-2xl overflow-hidden shadow-2xl h-full">
                            <?php
                            if (!empty($settings['hero_image']['id'])) {
                                $image_id = $settings['hero_image']['id'];
                                $image_url = esc_url($settings['hero_image']['url']);

                                // Get image metadata
                                $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                                $image_post = get_post($image_id);
                                $image_title = $image_post ? $image_post->post_title : '';

                                // Fallback if metadata is empty
                                $image_alt = !empty($image_alt) ? $image_alt : esc_attr($settings['project_title']);
                                $image_title = !empty($image_title) ? $image_title : esc_attr($settings['project_title']);

                                printf(
                                    '<img src="%s" class="w-full !h-64 sm:!h-96 lg:!h-full object-cover static lg:absolute" alt="%s" title="%s"/>',
                                    $image_url,
                                    esc_attr($image_alt),
                                    esc_attr($image_title)
                                );
                            }
                            ?>
                            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent">
                                <div class="absolute bottom-4 sm:bottom-8 left-4 sm:left-8 right-4 sm:right-8">
                                    <div class="bg-white/90 backdrop-blur-sm p-4 sm:p-6 rounded-xl">
                                        <h3 class="text-base sm:text-lg font-bold text-gray-900"><?php echo esc_html($settings['project_title']); ?></h3>
                                        <p class="text-sm sm:text-base text-gray-600 mt-0"><?php echo esc_html($settings['project_description']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Floating Cards - Updated classes -->
                        <div class="hidden lg:flex flex-col absolute -left-12 top-1/4 transform -translate-y-1/4 gap-6 sm:gap-8">
                            <div class="float bg-white p-6 rounded-xl shadow-xl hover:shadow-2xl transition-shadow max-w-[270px]">
                                <div class="flex gap-2 items-center">
                                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="w-12 h-12 rounded-full flex items-center justify-center">
                                        <svg style="color: <?php echo esc_attr($primary_color); ?>" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                    </div>
                                    <h4 class="font-semibold text-gray-900 text-base sm:text-lg"><?php echo esc_html($settings['quality_card_title']); ?></h4>
                                </div>
                                <p class="text-gray-600 mt-2"><?php echo esc_html($settings['quality_card_description']); ?></p>
                            </div>
                            <div class="float bg-white p-6 rounded-xl shadow-xl hover:shadow-2xl transition-shadow max-w-[270px]">
                                <div class="flex gap-2 items-center">
                                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="w-12 h-12 rounded-full flex items-center justify-center">
                                        <svg style="color: <?php echo esc_attr($primary_color); ?>" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                        </svg>
                                    </div>
                                    <h4 class="font-semibold text-gray-900 text-base sm:text-lg"><?php echo esc_html($settings['delivery_card_title']); ?></h4>
                                </div>
                                <p class="text-gray-600 mt-2"><?php echo esc_html($settings['delivery_card_description']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }
}
