<?php

/**
 * Project Description Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Project_Description extends \Elementor\Widget_Base
{
    /**
     * Get widget name.
     */
    public function get_name()
    {
        return 'project_description';
    }

    /**
     * Get widget title.
     */
    public function get_title()
    {
        return esc_html__('Project Description Section', 'dhaara-addon');
    }

    /**
     * Get widget icon.
     */
    public function get_icon()
    {
        return 'eicon-inner-section';
    }

    /**
     * Get widget categories.
     */
    public function get_categories()
    {
        return ['dhaara'];
    }

    /**
     * Register widget controls.
     */
    protected function register_controls()
    {
        // Header Section Controls
        $this->start_controls_section(
            'section_header',
            [
                'label' => esc_html__('Header', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Vision',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Project', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Vision', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Exploring the inspiration and philosophy behind Coastal Heights, where innovation meets sustainable living.', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Architectural Vision Section
        $this->start_controls_section(
            'section_architectural_vision',
            [
                'label' => esc_html__('Architectural Vision', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'arch_vision_title',
            [
                'label' => esc_html__('Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Architectural Vision', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'arch_vision_content',
            [
                'label' => esc_html__('Content', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => '<p>The project\'s distinctive silhouette against the coastal skyline is more than an architectural statement—it\'s a testament to our commitment to harmonious design.</p>',
            ]
        );

        $this->end_controls_section();

        // Design Philosophy Section
        $this->start_controls_section(
            'section_design_philosophy',
            [
                'label' => esc_html__('Design Philosophy', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'philosophy_title',
            [
                'label' => esc_html__('Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Design Philosophy', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'philosophy_content',
            [
                'label' => esc_html__('Content', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Our design philosophy centers on three core principles: human-centric spaces, environmental responsibility, and timeless elegance.', 'dhaara-addon'),
            ]
        );

        // Philosophy Features Repeater
        $philosophy_repeater = new \Elementor\Repeater();

        $philosophy_repeater->add_control(
            'feature_title',
            [
                'label' => esc_html__('Feature Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Human-Centric', 'dhaara-addon'),
            ]
        );

        $philosophy_repeater->add_control(
            'feature_description',
            [
                'label' => esc_html__('Feature Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Spaces designed around the way people live and interact', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'philosophy_features',
            [
                'label' => esc_html__('Philosophy Features', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $philosophy_repeater->get_controls(),
                'default' => [
                    [
                        'feature_title' => 'Human-Centric',
                        'feature_description' => 'Spaces designed around the way people live and interact',
                    ],
                    [
                        'feature_title' => 'Sustainable',
                        'feature_description' => 'Environmentally conscious design and materials',
                    ],
                ],
                'title_field' => '{{{ feature_title }}}',
            ]
        );

        $this->end_controls_section();

        // Quote Section
        $this->start_controls_section(
            'section_quote',
            [
                'label' => esc_html__('Quote', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'quote_content',
            [
                'label' => esc_html__('Quote Content', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Coastal Heights embodies our vision of creating not just buildings, but living ecosystems that enhance the quality of life for our residents while respecting and protecting our environment.', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'quote_author',
            [
                'label' => esc_html__('Author Name', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('James Davidson', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'quote_position',
            [
                'label' => esc_html__('Author Position', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Lead Architect', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Features Section
        $this->start_controls_section(
            'section_features',
            [
                'label' => esc_html__('Features', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $features_repeater = new \Elementor\Repeater();

        $features_repeater->add_control(
            'feature_icon',
            [
                'label' => esc_html__('Feature Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-bolt',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $features_repeater->add_control(
            'feature_title',
            [
                'label' => esc_html__('Feature Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Smart Integration', 'dhaara-addon'),
            ]
        );

        $features_repeater->add_control(
            'feature_description',
            [
                'label' => esc_html__('Feature Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Feature description goes here.', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'features_list',
            [
                'label' => esc_html__('Features', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $features_repeater->get_controls(),
                'default' => [
                    [
                        'feature_title' => 'Smart Integration',
                        'feature_description' => 'Seamlessly incorporating cutting-edge technology to enhance security, efficiency, and resident convenience throughout the development.',
                    ],
                    [
                        'feature_title' => 'Luxury Living',
                        'feature_description' => 'Premium amenities and finishes that define a new standard of coastal luxury living, from private balconies to resort-style facilities.',
                    ],
                    [
                        'feature_title' => 'Sustainable Design',
                        'feature_description' => 'Environmental consciousness meets luxury with energy-efficient systems, sustainable materials, and green spaces throughout.',
                    ],
                ],
                'title_field' => '{{{ feature_title }}}',
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFB600',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend.
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>
        <section class="project-description relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                </div>
            </div>

            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2  -translate-x-1/2  text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        <?php echo esc_html($settings['background_text']); ?>
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect">
                        <?php echo esc_html($settings['heading_text']); ?>
                        <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1">
                        <?php echo esc_html($settings['section_description']); ?>
                    </p>
                </div>

                <!-- Content Grid -->
                <div class="grid gap-6 sm:gap-8">
                    <!-- Vision Statement Card -->
                    <div class="bg-white rounded-2xl p-8 md:p-12 shadow-xl hover:shadow-2xl transition-shadow duration-300 fade-in-effect effect-1">
                        <div class="flex items-start gap-4">
                            <div>
                                <h3 class="text-2xl font-semibold text-gray-900 my-0"><?php echo esc_html($settings['arch_vision_title']); ?></h3>
                            </div>
                        </div>
                        <div class="max-w-none text-gray-600">
                            <?php echo wp_kses_post($settings['arch_vision_content']); ?>
                        </div>
                    </div>

                    <!-- Middle Row -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 sm:gap-8">
                        <!-- Design Philosophy Card -->
                        <div style="background-color: <?php echo esc_attr($primary_color); ?>" class="rounded-2xl p-8 text-white relative overflow-hidden fade-in-effect effect-1">
                            <div class="absolute top-0 right-0 w-64 h-64 bg-white/10 rounded-full -translate-x-24 -translate-y-24 blur-3xl"></div>
                            <div class="relative">
                                <h3 class="text-2xl font-semibold my-0"><?php echo esc_html($settings['philosophy_title']); ?></h3>
                                <p class=" leading-relaxed">
                                    <?php echo esc_html($settings['philosophy_content']); ?>
                                </p>
                                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 sm:gap-8 mt-8">
                                    <?php
                                    if (!empty($settings['philosophy_features'])) {
                                        foreach ($settings['philosophy_features'] as $feature) : ?>
                                            <div class="bg-white/10 rounded-xl p-4">
                                                <h4 class="font-semibold mb-2 text-xl mt-0"><?php echo esc_html($feature['feature_title']); ?></h4>
                                                <p class="text-sm mt-0"><?php echo esc_html($feature['feature_description']); ?></p>
                                            </div>
                                    <?php endforeach;
                                    } ?>
                                </div>
                            </div>
                        </div>

                        <!-- Quote Card -->
                        <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-md fade-in-effect effect-2">
                            <div class="h-full flex flex-col">
                                <svg style="color: <?php echo esc_attr($primary_color); ?>" class="w-12 h-12 mb-0" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z" />
                                </svg>
                                <p class="text-gray-600 italic text-lg mb-8 flex-grow">
                                    <?php echo esc_html($settings['quote_content']); ?>
                                </p>
                                <div class="flex items-center gap-4 mt-auto">
                                    <div style="background-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>" class="w-12 h-12 rounded-full bg-amber-100 flex items-center justify-center">
                                        <span style="color: <?php echo esc_attr($primary_color); ?>" class="font-semibold">
                                            <?php echo esc_html(substr($settings['quote_author'], 0, 2)); ?>
                                        </span>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-900"><?php echo esc_html($settings['quote_author']); ?></div>
                                        <div class="text-sm text-gray-500"><?php echo esc_html($settings['quote_position']); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Bottom Row - Feature Cards -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8 fade-in-effect effect-3">
                        <?php
                        if (!empty($settings['features_list'])) {
                            foreach ($settings['features_list'] as $feature) : ?>
                                <div class="bg-white rounded-2xl p-8 shadow-xl hover:shadow-2xl transition-shadow duration-300 group">
                                    <div style="background-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>" class="w-12 h-12 rounded-xl  flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">

                                        <?php
                                        if (!empty($feature['feature_icon']['value'])) {
                                            $icon_class = $feature['feature_icon']['value'];
                                            printf(
                                                '<i class="%s w-6 h-6 flex items-center justify-center" style="color: %s;"></i>',
                                                esc_attr($icon_class),
                                                esc_attr($primary_color)
                                            );
                                        }
                                        ?>
                                    </div>
                                    <h4 class="text-lg font-semibold text-gray-900 mb-2"><?php echo esc_html($feature['feature_title']); ?></h4>
                                    <p class="text-gray-600 mt-0">
                                        <?php echo esc_html($feature['feature_description']); ?>
                                    </p>
                                </div>
                        <?php endforeach;
                        } ?>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }

    /**
     * Render widget output in the editor.
     */
    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#FFB600' ;
            #>
            <section class="project-description relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                        <div style="background-color: {{ primaryColor }}30" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                    </div>
                </div>

                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <!-- Section Header -->
                    <div class="relative mb-12 sm:mb-16 text-center z-10">
                        <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                            {{{ settings.background_text }}}
                        </div>
                        <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900">
                            {{{ settings.heading_text }}}
                            <span style="color: {{ primaryColor }}">
                                {{{ settings.heading_span }}}
                            </span>
                        </h2>
                        <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto">
                            {{{ settings.section_description }}}
                        </p>
                    </div>

                    <div class="grid gap-6 sm:gap-8">
                        <div class="bg-white rounded-2xl p-8 md:p-12 shadow-xl hover:shadow-2xl transition-shadow duration-300">
                            <div class="flex items-start gap-4">
                                <div>
                                    <h3 class="text-2xl font-semibold text-gray-900 my-0">{{{ settings.arch_vision_title }}}</h3>
                                </div>
                            </div>
                            <div class="prose prose-blue max-w-none text-gray-600">
                                {{{ settings.arch_vision_content }}}
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 sm:gap-8">
                            <div style="background-color: {{ primaryColor }}" class="rounded-2xl p-8 text-white relative overflow-hidden">
                                <div class="absolute top-0 right-0 w-64 h-64 bg-white/10 rounded-full -translate-x-24 -translate-y-24 blur-3xl"></div>
                                <div class="relative">
                                    <h3 class="text-2xl font-semibold my-0">{{{ settings.philosophy_title }}}</h3>
                                    <p class="text-amber-50 leading-relaxed">
                                        {{{ settings.philosophy_content }}}
                                    </p>
                                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 sm:gap-8 mt-8">
                                        <# _.each(settings.philosophy_features, function(feature) { #>
                                            <div class="bg-white/10 rounded-xl p-4">
                                                <h4 class="font-semibold mb-2 text-xl mt-0">{{{ feature.feature_title }}}</h4>
                                                <p class="text-sm mt-0 text-amber-100">{{{ feature.feature_description }}}</p>
                                            </div>
                                            <# }); #>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-md transition-all">
                                <div class="h-full flex flex-col">
                                    <svg style="color: {{ primaryColor }}" class="w-12 h-12 mb-0" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z" />
                                    </svg>
                                    <p class="text-gray-600 italic text-lg mb-8 flex-grow">
                                        {{{ settings.quote_content }}}
                                    </p>
                                    <div class="flex items-center gap-4 mt-auto">
                                        <div style="background-color: {{ primaryColor }}10" class="w-12 h-12 rounded-full flex items-center justify-center">
                                            <span style="color: {{ primaryColor }}" class="font-semibold">
                                                {{{ settings.quote_author.substr(0, 2) }}}
                                            </span>
                                        </div>
                                        <div>
                                            <div class="font-semibold text-gray-900">{{{ settings.quote_author }}}</div>
                                            <div class="text-sm text-gray-500">{{{ settings.quote_position }}}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                            <# _.each(settings.features_list, function(feature) { #>
                                <div class="bg-white rounded-2xl p-8 shadow-xl hover:shadow-2xl transition-shadow duration-300 group">
                                    <div style="background-color: {{ primaryColor }}20" class="w-12 h-12 rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">

                                        <# if (feature.feature_icon.value) { #>
                                            <i style="color: {{ primaryColor }}" class="{{ feature.feature_icon.value }} w-6 h-6 text-primary-amber flex items-center justify-center"></i>
                                            <# } #>

                                    </div>
                                    <h4 class="text-lg font-semibold text-gray-900 mb-2">{{{ feature.feature_title }}}</h4>
                                    <p class="text-gray-600 mt-0">
                                        {{{ feature.feature_description }}}
                                    </p>
                                </div>
                                <# }); #>
                        </div>
                    </div>
                </div>
            </section>
    <?php
    }
}
