<?php

/**
 * Stats Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Stats extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'stats';
    }
    public function get_title()
    {
        return esc_html__('Stats Section', 'dhaara-addon');
    }
    public function get_icon()
    {
        return 'eicon-number-field';
    }
    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_stats',
            [
                'label' => esc_html__('Stats', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'stat_icon',
            [
                'label' => esc_html__('Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => ['value' => 'fas fa-star'],
            ]
        );

        $repeater->add_control(
            'stat_number',
            [
                'label' => esc_html__('Number', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '500+',
            ]
        );

        $repeater->add_control(
            'stat_label',
            [
                'label' => esc_html__('Label', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Projects Completed',
            ]
        );

        $this->add_control(
            'stats_list',
            [
                'label' => esc_html__('Stats', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['stat_number' => '500+', 'stat_label' => 'Projects Completed'],
                    ['stat_number' => '250+', 'stat_label' => 'Expert Team'],
                    ['stat_number' => '100%', 'stat_label' => 'Success Rate'],
                    ['stat_number' => '15+', 'stat_label' => 'Years Experience'],
                ],
                'title_field' => '{{{ stat_label }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFB600',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>
        <section class="stats-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>

                </div>
            </div>

            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <div class="space-y-20">
                    <div class="relative fade-in-effect">
                        <div style="background: linear-gradient(to right, <?php echo esc_attr($primary_color); ?>, <?php echo esc_attr($primary_color); ?>)" class="absolute inset-0 rounded-3xl rotate-1 blur opacity-10"></div>
                        <div class="relative bg-white backdrop-blur-xl rounded-3xl p-12 hover:shadow-2xl transition-all duration-500">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-8 ">
                                <?php foreach ($settings['stats_list'] as $stat) : ?>
                                    <div class="text-center space-y-2 group">
                                        <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="inline-flex w-16 h-16 items-center justify-center rounded-2xl group-hover:bg-primary-amber transition-colors duration-300">
                                            <?php if (!empty($stat['stat_icon']['value'])) : ?>
                                                <i style="color: <?php echo esc_attr($primary_color); ?>" class="<?php echo esc_attr($stat['stat_icon']['value']); ?> flex items-center justify-center w-8 h-8   group-hover:text-white transition-colors duration-300"></i>
                                            <?php endif; ?>
                                        </div>
                                        <div class="text-4xl font-bold text-gray-900"><?php echo esc_html($stat['stat_number']); ?></div>
                                        <div class="text-sm text-gray-600"><?php echo esc_html($stat['stat_label']); ?></div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }

    protected function content_template()
    {
    ?>
        <# var primaryColor=settings.primary_color || '#FFB600' ; #>
            <section class="stats-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                        <div style="background-color: {{ primaryColor }}30" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                    </div>
                </div>
                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <div class="space-y-20">
                        <div class="relative mb-20">
                            <div style="background: linear-gradient(to right, {{ primaryColor }}, {{ primaryColor }})" class="absolute inset-0 rounded-3xl rotate-1 blur opacity-10"></div>
                            <div class="relative bg-white backdrop-blur-xl rounded-3xl p-12 hover:shadow-2xl transition-all duration-500">
                                <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                                    <# _.each(settings.stats_list, function(stat) { #>
                                        <div class="text-center space-y-2 group">
                                            <div style="background-color: {{ primaryColor }}20" class="inline-flex w-16 h-16 items-center justify-center rounded-2xl group-hover:bg-primary-amber transition-colors duration-300">
                                                <# if (stat.stat_icon.value) { #>
                                                    <i style="color: {{ primaryColor }}" class="{{ stat.stat_icon.value }} flex items-center justify-center w-8 h-8   group-hover:text-white transition-colors duration-300"></i>
                                                    <# } #>
                                            </div>
                                            <div class="text-4xl font-bold text-gray-900">{{{ stat.stat_number }}}</div>
                                            <div class="text-sm text-gray-600">{{{ stat.stat_label }}}</div>
                                        </div>
                                        <# }); #>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
    <?php
    }
}
