<?php
class Client_Logo_Slider_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'client_logo_slider';
    }

    public function get_title()
    {
        return 'Client Logo Slider';
    }

    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        // Header Section
        $this->start_controls_section(
            'header_section',
            [
                'label' => 'Header',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Our Clients',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Trusted by Industry', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Leaders', 'dhaara-addon'),
            ]
        );



        $this->add_control(
            'section_description',
            [
                'label' => 'Description',
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'We\'re proud to work with forward-thinking organizations that share our vision for innovative and sustainable architecture.',
            ]
        );

        $this->end_controls_section();

        // Logos Section
        $this->start_controls_section(
            'logos_section',
            [
                'label' => 'Client Logos',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'client_logo',
            [
                'label' => 'Client Logo',
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'client_name',
            [
                'label' => 'Client Name',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Client Name',
            ]
        );

        $this->add_control(
            'logo_list',
            [
                'label' => 'Client Logos',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'client_name' => 'Client 1',
                    ],
                    [
                        'client_name' => 'Client 2',
                    ],
                ],
                'title_field' => '{{{ client_name }}}',
            ]
        );

        $this->end_controls_section();



        // Style Sections...
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>
        <section class="client-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Section Header -->
            <div class="relative mb-12 sm:mb-16 text-center z-10">
                <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                    <?php echo esc_html($settings['background_text']); ?>
                </div>
                <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect is-visible">
                    <?php echo esc_html($settings['heading_text']); ?>
                    <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-2 is-visible">
                    <?php echo esc_html($settings['section_description']); ?>
                </p>
            </div>

            <!-- Logo Slider Container -->
            <div class="relative max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <!-- Slider Track -->
                <div class="flex space-x-16 animate-scroll">
                    <!-- Original Logo Group -->
                    <div class="flex space-x-16 items-center ">
                        <?php foreach ($settings['logo_list'] as $logo) : ?>
                            <div class="group relative">
                                <div class="absolute -inset-1 bg-gradient-to-r   rounded-lg blur opacity-0 group-hover:opacity-20 transition-opacity"></div>
                                <div class="relative bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                                    <div class="w-32 h-16 flex items-center justify-center">
                                        <img decoding="async" src="<?php echo esc_url($logo['client_logo']['url']); ?>"
                                            alt="<?php echo esc_attr($logo['client_name']); ?>"
                                            class="max-w-full max-h-full grayscale group-hover:grayscale-0 transition-all">
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <!-- Duplicated Logo Group -->
                    <div class="flex space-x-16 items-center">
                        <?php foreach ($settings['logo_list'] as $logo) : ?>
                            <div class="group relative">
                                <div class="absolute -inset-1 bg-gradient-to-r    rounded-lg blur opacity-0 group-hover:opacity-20 transition-opacity"></div>
                                <div class="relative bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                                    <div class="w-32 h-16 flex items-center justify-center">
                                        <img decoding="async" src="<?php echo esc_url($logo['client_logo']['url']); ?>"
                                            alt="<?php echo esc_attr($logo['client_name']); ?>"
                                            class="max-w-full max-h-full grayscale group-hover:grayscale-0 transition-all">
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>

        <style>
            @keyframes scroll {
                0% {
                    transform: translateX(0);
                }

                100% {
                    transform: translateX(calc(-50% - 2rem));
                }
            }

            @keyframes blob {
                0% {
                    transform: translate(0px, 0px) scale(1);
                }

                33% {
                    transform: translate(30px, -50px) scale(1.1);
                }

                66% {
                    transform: translate(-20px, 20px) scale(0.9);
                }

                100% {
                    transform: translate(0px, 0px) scale(1);
                }
            }

            .animate-scroll {
                animation: scroll 30s linear infinite;
            }

            .animate-blob {
                animation: blob 7s infinite;
            }

            .animation-delay-2000 {
                animation-delay: 2s;
            }
        </style>
    <?php
    }

    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#FFB600' ;
            #>
            <section class="client-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        {{{ settings.background_text }}}
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900  is-visible">
                        {{{ settings.heading_text }}}
                        <span style="color: {{ primaryColor }}">{{{ settings.heading_span }}}</span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto   is-visible">
                        {{{ settings.section_description }}}
                    </p>
                </div>

                <!-- Logo Slider Container -->
                <div class="relative max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <!-- Slider Track -->
                    <div class="flex space-x-16 animate-scroll">
                        <!-- Original Logo Group -->
                        <div class="flex space-x-16 items-center">
                            <# _.each(settings.logo_list, function(logo) { #>
                                <div class="group relative">
                                    <div class="absolute -inset-1 bg-gradient-to-r rounded-lg blur opacity-0 group-hover:opacity-20 transition-opacity"></div>
                                    <div class="relative bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                                        <div class="w-32 h-16 flex items-center justify-center">
                                            <img decoding="async" src="{{ logo.client_logo.url }}"
                                                alt="{{ logo.client_name }}"
                                                class="max-w-full max-h-full grayscale group-hover:grayscale-0 transition-all">
                                        </div>
                                    </div>
                                </div>
                                <# }); #>
                        </div>

                        <!-- Duplicated Logo Group -->
                        <div class="flex space-x-16 items-center">
                            <# _.each(settings.logo_list, function(logo) { #>
                                <div class="group relative">
                                    <div class="absolute -inset-1 bg-gradient-to-r rounded-lg blur opacity-0 group-hover:opacity-20 transition-opacity"></div>
                                    <div class="relative bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                                        <div class="w-32 h-16 flex items-center justify-center">
                                            <img decoding="async" src="{{ logo.client_logo.url }}"
                                                alt="{{ logo.client_name }}"
                                                class="max-w-full max-h-full grayscale group-hover:grayscale-0 transition-all">
                                        </div>
                                    </div>
                                </div>
                                <# }); #>
                        </div>
                    </div>
                </div>
            </section>
    <?php
    }
}
    ?>