<?php

/**
 * Project Widget
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Projects_Grid_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'projects_grid';
    }

    public function get_title()
    {
        return __('Projects Grid', 'dhaara-addon');
    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'PORTFOLIO',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Latest', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Projects', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => __('Section Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Discover our most recent architectural achievements, where innovation meets excellence in design and execution.', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'learn_more_text',
            [
                'label' => esc_html__('Learn More Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Learn More', 'dhaara-addon'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        // Add Featured Project Section
        $this->start_controls_section(
            'featured_project_section',
            [
                'label' => esc_html__('Project Box', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'featured_project',
            [
                'label' => esc_html__('Select Featured Project', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_projects_options(),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'show_featured_project',
            [
                'label' => esc_html__('Show Featured Project', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Number of Regular Projects', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 4,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_section',
            [
                'label' => esc_html__('View All Button', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_button',
            [
                'label' => esc_html__('Show Button', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('View All Projects', 'dhaara-addon'),
                'condition' => [
                    'show_button' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => esc_html__('Button Link', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'show_button' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY
                ]
            ]
        );

        $this->end_controls_section();
    }

    private function get_projects_options()
    {
        $projects = get_posts([
            'post_type' => 'project',
            'posts_per_page' => -1,
            'orderby' => 'title',
            'order' => 'ASC',
        ]);

        $options = [];
        foreach ($projects as $project) {
            $options[$project->ID] = $project->post_title;
        }
        return $options;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
        $featured_project_id = $settings['featured_project'];
        $show_featured = $settings['show_featured_project'] === 'yes';
        $learn_more_text = !empty($settings['learn_more_text']) ? $settings['learn_more_text'] : "Learn More";

        // Query for regular projects
        $args = [
            'post_type' => 'project',
            'posts_per_page' => $settings['posts_per_page'],
            'post__not_in' => $show_featured && $featured_project_id ? [$featured_project_id] : [],
        ];
        $regular_query = new WP_Query($args);

?>

        <section class="project-grid-section relative py-16 sm:py-20 lg:py-20 overflow-hidden z-10">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">

                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                </div>
            </div>

            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        <?php echo esc_html($settings['background_text']); ?>
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect is-visible">
                        <?php echo esc_html($settings['heading_text']); ?>
                        <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                    </h2>
                    <p class="mt-4 text-xl max-w-2xl mx-auto fade-in-effect effect-1 is-visible">
                        <?php echo esc_html($settings['section_description']); ?>
                    </p>
                </div>

                <!-- Projects Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 sm:gap-8">
                    <?php
                    // Featured Project
                    if ($show_featured && $featured_project_id):
                        $featured_project = get_post($featured_project_id);
                        if ($featured_project):
                            $categories = get_the_terms($featured_project_id, 'project_category');
                            $document = \Elementor\Plugin::$instance->documents->get($featured_project_id);
                            if ($document) {
                                $projectSettings = $document->get_settings_for_display();
                                $completion_date = isset($projectSettings['project_completion_date']) ? $projectSettings['project_completion_date'] : '';
                                $progress = isset($projectSettings['project_progress']) ? $projectSettings['project_progress'] : '0';
                            }


                    ?>
                            <div class="md:col-span-2 fade-in-effect effect-1 is-visible">
                                <div class="group relative rounded-2xl overflow-hidden">
                                    <?php if (has_post_thumbnail($featured_project_id)): ?>
                                        <?php $thumbnail_url = wp_get_attachment_image_url(get_post_thumbnail_id($featured_project_id), 'full');

                                        if ($thumbnail_url) {
                                            echo '<img src="' . esc_url($thumbnail_url) . '" class="w-full h-[300px] sm:h-[400px] lg:h-[500px] object-cover" alt="' . esc_attr(get_the_title($featured_project_id)) . '">';
                                        } ?>
                                    <?php else: ?>
                                        <div class="w-full h-[300px] sm:h-[400px] lg:h-[500px] bg-gray-200 flex items-center justify-center">
                                            <svg class="w-20 h-20 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                    <?php endif; ?>
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/30 to-transparent">
                                        <?php if ($completion_date): ?>
                                            <div class="absolute top-4 right-4 sm:right-8 backdrop-blur-md bg-white/10 border border-white/20 rounded-full pl-2 pr-3 py-1 flex items-center gap-2">
                                                <span class="w-2 h-2 rounded-full bg-gray-400 animate-pulse"></span>
                                                <span class="text-white text-sm font-medium"> <?php echo __('Completed ', 'dhaara-addon') . esc_html(date('Y', strtotime($completion_date))); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/30 to-transparent">
                                            <div class="absolute bottom-4 sm:bottom-8 left-4 sm:left-8 right-4 sm:right-8 transform transition-all duration-500 ">
                                                <div class="bg-white backdrop-blur-sm p-4 sm:p-6 rounded-2xl">
                                                    <div class="flex flex-wrap items-center justify-between gap-2 mb-4">
                                                        <span style="background-color: <?php echo esc_attr(adjust_color_brightness($primary_color, 40, 0.1)); ?>; color: <?php echo esc_attr($primary_color); ?>" class="px-3 sm:px-4 py-1 rounded-full text-sm font-medium">
                                                            <?php echo __('Featured Project', 'dhaara-addon'); ?>
                                                        </span>

                                                    </div>
                                                    <h3 class="text-xl sm:text-2xl font-bold text-gray-900 mb-2">
                                                        <?php echo esc_html($featured_project->post_title); ?>
                                                    </h3>
                                                    <p class="text-sm sm:text-base line-clamp-2 ">
                                                        <?php echo esc_html($featured_project->post_excerpt); ?>
                                                    </p>

                                                    <!-- Progress Bar -->
                                                    <div class="space-y-2 mt-4">
                                                        <div class="flex justify-between text-sm">
                                                            <span><?php echo esc_html("Project Progress", "dhaara-addon"); ?></span>
                                                            <span class="text-gray-900 font-medium"><?php echo esc_html($progress . "%"); ?></span>
                                                        </div>
                                                        <div class="h-2 bg-gray-100 rounded-full overflow-hidden">
                                                            <div class="h-full  bg-primary-amber rounded-full" style="background-color: <?php echo esc_attr($primary_color); ?>;width: <?php echo esc_attr($progress); ?>%"></div>
                                                        </div>
                                                    </div>

                                                    <a href="<?php echo esc_url(get_the_permalink($featured_project->ID)); ?>"
                                                        class="inline-flex items-center font-semibold group-hover:translate-x-2 transition-all duration-300  mt-4"
                                                        style="color: <?php echo esc_attr($primary_color); ?>">
                                                        <?php echo esc_html($learn_more_text); ?>
                                                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php
                        endif;
                    endif;
                    ?>

                    <!-- Regular Projects -->
                    <?php
                    $counter = 1;
                    if ($regular_query->have_posts()):
                        while ($regular_query->have_posts()): $regular_query->the_post();
                            $categories = get_the_terms(get_the_ID(), 'project_category');
                            $post = get_post(get_the_ID());
                            $document = \Elementor\Plugin::$instance->documents->get(get_the_ID());
                            if ($document) {
                                $projectSettings = $document->get_settings_for_display();
                                $completion_date = isset($projectSettings['project_completion_date']) ? $projectSettings['project_completion_date'] : '';
                                $progress = isset($projectSettings['project_progress']) ? $projectSettings['project_progress'] : '0';
                            }
                    ?>
                            <div>
                                <div class="group relative rounded-2xl overflow-hidden fade-in-effect effect-<?php echo esc_attr($counter); ?> is-visible">
                                    <?php if (has_post_thumbnail()): ?>
                                        <?php the_post_thumbnail('full', ['class' => 'w-full h-[250px] sm:h-[300px] lg:h-[400px] object-cover transform transition-transform duration-500 group-hover:scale-110']); ?>
                                    <?php else: ?>
                                        <div class="w-full h-[250px] sm:h-[300px] lg:h-[400px] bg-gray-200 flex items-center justify-center">
                                            <svg class="w-16 h-16 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                    <?php endif; ?>
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent">
                                        <?php if ($completion_date): ?>
                                            <div class="absolute top-4 right-4 sm:right-8 backdrop-blur-md bg-white/10 border border-white/20 rounded-full pl-2 pr-3 py-1 flex items-center gap-2">
                                                <span class="w-2 h-2 rounded-full bg-gray-400 animate-pulse"></span>
                                                <span class="text-white text-sm font-medium"> <?php echo __('Completed ', 'dhaara-addon') . esc_html(date('Y', strtotime($completion_date))); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent">
                                            <div class="absolute bottom-4 sm:bottom-8 left-4 sm:left-8 right-4 sm:right-8">
                                                <div class="bg-white backdrop-blur-sm p-4 sm:p-6 rounded-2xl">
                                                    <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-2">
                                                        <?php echo esc_html(get_the_title()); ?>
                                                    </h3>
                                                    <p class="text-sm sm:text-base line-clamp-2 "><?php echo esc_html($post->post_excerpt); ?></p>

                                                    <!-- Progress Bar -->
                                                    <div class="space-y-2 mt-4">
                                                        <div class="flex justify-between text-sm">
                                                            <span><?php echo esc_html("Project Progress", "dhaara-addon"); ?></span>
                                                            <span class="text-gray-900 font-medium"><?php echo esc_html($progress . "%"); ?></span>
                                                        </div>
                                                        <div class="h-2 bg-gray-100 rounded-full overflow-hidden">
                                                            <div class="h-full  bg-primary-amber rounded-full" style="background-color: <?php echo esc_attr($primary_color); ?>;width: <?php echo esc_attr($progress); ?>%"></div>
                                                        </div>
                                                    </div>

                                                    <a href="<?php echo esc_url(get_the_permalink()); ?>"
                                                        class="inline-flex items-center font-semibold group-hover:translate-x-2 transition-all duration-300  mt-4"
                                                        style="color: <?php echo esc_attr($primary_color); ?>">
                                                        <?php echo esc_html($learn_more_text); ?>
                                                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                $counter++;
                                ?>
                            </div>
                    <?php
                        endwhile;
                    endif;
                    wp_reset_postdata(); ?>

                    <!-- View All Projects Button -->
                    <?php if ($settings['show_button'] === 'yes') :
                        $button_url = !empty($settings['button_link']['url']) ?
                            $settings['button_link']['url'] :
                            get_post_type_archive_link('project');
                    ?>
                        <div class="md:col-span-2 text-center mt-8 sm:mt-12">
                            <a href="<?php echo esc_url($button_url); ?>"
                                style="background-color: <?php echo esc_attr($primary_color); ?>; --hover-color: <?php echo esc_attr($primary_color); ?>;"
                                class="group inline-flex items-center gap-2 px-6 sm:px-8 py-3 sm:py-4 text-white font-semibold rounded-lg transition-all duration-300 hover:scale-105 shadow-lg hover:shadow-xl"
                                <?php echo $settings['button_link']['is_external'] ? 'target="_blank"' : ''; ?>
                                <?php echo $settings['button_link']['nofollow'] ? 'rel="nofollow"' : ''; ?>>
                                <?php echo esc_html($settings['button_text']); ?>
                                <svg class="w-5 h-5 transform group-hover:translate-x-2 transition-transform"
                                    fill="none"
                                    stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round"
                                        stroke-linejoin="round"
                                        stroke-width="2"
                                        d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
<?php
    }
}
