<?php

/**
 * Services Box Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Service_Boxes extends \Elementor\Widget_Base
{
    /**
     * Get widget name.
     */
    public function get_name()
    {
        return 'service_boxes';
    }

    /**
     * Get widget title.
     */
    public function get_title()
    {
        return esc_html__('Services Box Section', 'dhaara-addon');
    }

    /**
     * Get widget icon.
     */
    public function get_icon()
    {
        return 'eicon-inner-section';
    }

    /**
     * Get widget categories.
     */
    public function get_categories()
    {
        return ['dhaara'];
    }

    /**
     * Register widget controls.
     */
    protected function register_controls()
    {
        // Header Section Controls
        $this->start_controls_section(
            'section_header',
            [
                'label' => esc_html__('Header', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Services',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Building Excellence, Delivering', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Value', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Discover how our expertise in commercial construction can transform your vision into reality', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Service Features Controls
        $this->start_controls_section(
            'section_features',
            [
                'label' => esc_html__('Service Features', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $features_repeater = new \Elementor\Repeater();

        $features_repeater->add_control(
            'feature_icon',
            [
                'label' => esc_html__('Feature Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-building',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $features_repeater->add_control(
            'feature_title',
            [
                'label' => esc_html__('Feature Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Feature Title', 'dhaara-addon'),
            ]
        );

        $features_repeater->add_control(
            'feature_description',
            [
                'label' => esc_html__('Feature Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Feature description goes here.', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'features_list',
            [
                'label' => esc_html__('Features', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $features_repeater->get_controls(),
                'default' => [
                    [
                        'feature_title' => 'Innovative Design',
                        'feature_description' => 'Utilizing cutting-edge architectural concepts and sustainable building practices.',
                    ],
                    [
                        'feature_title' => 'Quality Assurance',
                        'feature_description' => 'Rigorous quality control processes ensuring excellence at every stage.',
                    ],
                    [
                        'feature_title' => 'Timely Delivery',
                        'feature_description' => 'Efficient project management ensuring on-time completion.',
                    ],
                ],
                'title_field' => '{{{ feature_title }}}',
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFB600',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend.
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>
        <section class="services-box relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                </div>
            </div>

            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2  -translate-x-1/2  text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        <?php echo esc_html($settings['background_text']); ?>
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect ">
                        <?php echo esc_html($settings['heading_text']); ?>
                        <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1">
                        <?php echo esc_html($settings['section_description']); ?>
                    </p>
                </div>

                <!-- Service Features Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8 fade-in-effect effect-2">
                    <?php
                    if (!empty($settings['features_list'])) {
                        foreach ($settings['features_list'] as $feature) :
                    ?>
                            <div class="group relative">
                                <div style="background-color: <?php echo esc_attr($primary_color); ?>50" class="absolute inset-0  rounded-2xl blur opacity-0 group-hover:opacity-20 transition-all duration-500"></div>
                                <div class="relative bg-white/80 shadow-lg backdrop-blur-lg rounded-2xl p-8 hover:shadow-xl transition-all duration-500 h-full">
                                    <div class="mb-6 relative">
                                        <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="w-14 h-14 rounded-xl flex items-center justify-center group-hover:bg-primary-amber transition-colors duration-300">
                                            <?php
                                            if (!empty($feature['feature_icon']['value'])) {
                                                $icon_class = $feature['feature_icon']['value'];
                                                printf(
                                                    '<i class="%s w-7 h-7  flex items-center justify-center group-hover:text-white transition-colors duration-300" style="color: %s;"></i>',
                                                    esc_attr($icon_class),
                                                    esc_attr($primary_color)
                                                );
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-3">
                                        <?php echo esc_html($feature['feature_title']); ?>
                                    </h3>
                                    <p class="text-gray-600">
                                        <?php echo esc_html($feature['feature_description']); ?>
                                    </p>
                                </div>
                            </div>
                    <?php
                        endforeach;
                    }
                    ?>
                </div>
            </div>
        </section>
    <?php
    }

    /**
     * Render widget output in the editor.
     */
    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#FFB600' ;
            #>
            <section class="services-box relative py-16 sm:py-20 lg:py-20 overflow-hidden">
                <!-- Animated Background -->
                <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
                        <div style="background-color: {{ primaryColor }}20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
                    </div>
                </div>

                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <!-- Modern Service Summary -->
                    <div class="relative mb-12 sm:mb-16 text-center z-10">
                        <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                            {{{ settings.background_text }}}
                        </div>
                        <h2 class="relative text-5xl font-bold text-gray-900">
                            {{{ settings.heading_text }}}
                            <span style="color: {{ primaryColor }}">
                                {{{ settings.heading_span }}}
                            </span>
                        </h2>
                        <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto">
                            {{{ settings.description }}}
                        </p>
                    </div>

                    <!-- Service Features Grid -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                        <# if ( settings.features_list ) { #>
                            <# _.each( settings.features_list, function( feature ) { #>
                                <div class="group relative">
                                    <div style="background-color: {{ primaryColor }}50" class="absolute inset-0  rounded-2xl blur opacity-0 group-hover:opacity-20 transition-all duration-500"></div>
                                    <div class="relative bg-white/80 shadow-lg backdrop-blur-lg rounded-2xl p-8 hover:shadow-xl transition-all duration-500 h-full">
                                        <div class="mb-6 relative">
                                            <div style="background-color: {{ primaryColor }}20" class="w-14 h-14 rounded-xl flex items-center justify-center group-hover:bg-primary-amber transition-colors duration-300">
                                                <# if ( feature.feature_icon.value ) { #>
                                                    <i style="color: {{ primaryColor }}" class="{{ feature.feature_icon.value }}  w-7 h-7  flex items-center justify-center group-hover:text-white transition-colors duration-300"></i>
                                                    <# } #>
                                            </div>
                                        </div>
                                        <h3 class="text-xl font-bold text-gray-900 mb-3">
                                            {{{ feature.feature_title }}}
                                        </h3>
                                        <p class="text-gray-600">
                                            {{{ feature.feature_description }}}
                                        </p>
                                    </div>
                                </div>
                                <# }); #>
                                    <# } #>
                    </div>
                </div>
            </section>
    <?php
    }
}
