<?php

/**
 * Team Section Widget for Elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Team_Section_Widget extends \Elementor\Widget_Base
{

    /**
     * Get widget name.
     */
    public function get_name()
    {
        return 'team_section';
    }

    /**
     * Get widget title.
     */
    public function get_title()
    {
        return esc_html__('Team Section', 'dhaara-addon');
    }

    /**
     * Get widget icon.
     */
    public function get_icon()
    {
        return 'eicon-person';
    }

    /**
     * Get widget categories.
     */
    public function get_categories()
    {
        return ['dhaara'];
    }

    /**
     * Register widget controls.
     */
    protected function register_controls()
    {
        // Header Section Controls
        $this->start_controls_section(
            'section_header',
            [
                'label' => esc_html__('Header', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'OUR TEAM',
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'your-dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('The Minds Behind', 'your-dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'your-dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Dharā', 'your-dhaara-addon'),
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__('Section Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Our diverse team of architects, designers, and innovators brings together decades of experience to create extraordinary spaces.', 'dhaara-addon'),
            ]
        );

        $this->end_controls_section();

        // Leadership Team Controls
        $this->start_controls_section(
            'section_leadership',
            [
                'label' => esc_html__('Leadership Team', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'leadership_heading',
            [
                'label' => esc_html__('Leadership Section Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Leadership Team', 'dhaara-addon'),
            ]
        );

        $leadership_repeater = new \Elementor\Repeater();

        $leadership_repeater->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('John Doe', 'dhaara-addon'),
            ]
        );

        $leadership_repeater->add_control(
            'position',
            [
                'label' => esc_html__('Position', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('CEO', 'dhaara-addon'),
            ]
        );

        $leadership_repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // New Social Media Controls for Leadership
        $leadership_repeater->add_control(
            'linkedin_icon',
            [
                'label' => esc_html__('LinkedIn Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-linkedin',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $leadership_repeater->add_control(
            'linkedin_url',
            [
                'label' => esc_html__('LinkedIn URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://linkedin.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $leadership_repeater->add_control(
            'twitter_icon',
            [
                'label' => esc_html__('Twitter Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-twitter',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $leadership_repeater->add_control(
            'twitter_url',
            [
                'label' => esc_html__('Twitter URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://twitter.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $leadership_repeater->add_control(
            'facebook_icon',
            [
                'label' => esc_html__('Facebook Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $leadership_repeater->add_control(
            'facebook_url',
            [
                'label' => esc_html__('Facebook URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://facebook.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $leadership_repeater->add_control(
            'instagram_icon',
            [
                'label' => esc_html__('Instagram Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-instagram',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $leadership_repeater->add_control(
            'instagram_url',
            [
                'label' => esc_html__('Instagram URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://instagram.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'leadership_members',
            [
                'label' => esc_html__('Leadership Members', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $leadership_repeater->get_controls(),
                'default' => [
                    [
                        'name' => esc_html__('Emma Thompson', 'dhaara-addon'),
                        'position' => esc_html__('Design Director', 'dhaara-addon'),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        // Core Team Controls
        $this->start_controls_section(
            'section_core_team',
            [
                'label' => esc_html__('Core Team', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'core_team_heading',
            [
                'label' => esc_html__('Core Team Section Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Core Team', 'dhaara-addon'),
            ]
        );

        $core_team_repeater = new \Elementor\Repeater();

        $core_team_repeater->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('John Doe', 'dhaara-addon'),
            ]
        );

        $core_team_repeater->add_control(
            'position',
            [
                'label' => esc_html__('Position', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Developer', 'dhaara-addon'),
            ]
        );

        $core_team_repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // New Social Media Controls for Core Team
        $core_team_repeater->add_control(
            'linkedin_icon',
            [
                'label' => esc_html__('LinkedIn Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-linkedin',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $core_team_repeater->add_control(
            'linkedin_url',
            [
                'label' => esc_html__('LinkedIn URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://linkedin.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $core_team_repeater->add_control(
            'twitter_icon',
            [
                'label' => esc_html__('Twitter Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-twitter',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $core_team_repeater->add_control(
            'twitter_url',
            [
                'label' => esc_html__('Twitter URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://twitter.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $core_team_repeater->add_control(
            'facebook_icon',
            [
                'label' => esc_html__('Facebook Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $core_team_repeater->add_control(
            'facebook_url',
            [
                'label' => esc_html__('Facebook URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://facebook.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $core_team_repeater->add_control(
            'instagram_icon',
            [
                'label' => esc_html__('Instagram Icon', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-instagram',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $core_team_repeater->add_control(
            'instagram_url',
            [
                'label' => esc_html__('Instagram URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://instagram.com/',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );



        $this->add_control(
            'core_team_members',
            [
                'label' => esc_html__('Core Team Members', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $core_team_repeater->get_controls(),
                'default' => [
                    [
                        'name' => esc_html__('Jane Doe', 'dhaara-addon'),
                        'position' => esc_html__('Developer', 'dhaara-addon'),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        // Join Team Section Controls
        $this->start_controls_section(
            'section_join_team',
            [
                'label' => esc_html__('Join Team Section', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'join_title',
            [
                'label' => esc_html__('Title', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Join Our Team', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'join_description',
            [
                'label' => esc_html__('Description', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('We\'re always looking for talented individuals to join our growing team.', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('View Open Positions', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => esc_html__('Button URL', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Sections...
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY
                ]
            ]
        );

        $this->end_controls_section();
    }


    /**
     * Render widget output on the frontend.
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
?>
        <section class="team-section py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
                </div>
            </div>

            <!-- Section Header -->
            <div class="relative mb-12 sm:mb-16 text-center z-10">
                <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                    <?php echo esc_html($settings['background_text']); ?>
                </div>
                <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect ">
                    <?php echo esc_html($settings['heading_text']); ?>
                    <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-1">
                    <?php echo esc_html($settings['section_description']); ?>
                </p>
            </div>


            <!-- Leadership Team -->
            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <?php if (!empty($settings['leadership_members'])) : ?>
                    <div class="mb-24">
                        <h3 class="text-4xl font-bold text-gray-900 mb-12 text-center fade-in-effect  effect-2"> <?php echo esc_html($settings['leadership_heading']); ?></h3>
                        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                            <?php foreach ($settings['leadership_members'] as $member) : ?>
                                <div class="group relative fade-in-effect effect-3">
                                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                    <div class="relative bg-white rounded-2xl overflow-hidden shadow-xl hover:shadow-2xl transition-shadow duration-300">
                                        <div class="aspect-[4/5] overflow-hidden">
                                            <?php
                                            if (!empty($member['image']['id'])) {
                                                echo wp_get_attachment_image($member['image']['id'], 'full', false, [
                                                    'class' => 'w-full h-full object-cover transform transition-transform duration-700 group-hover:scale-110'
                                                ]);
                                            }
                                            ?>
                                        </div>
                                        <div class="absolute inset-0 bg-gradient-to-t from-gray-900 via-gray-900/40 to-transparent opacity-0 group-hover:opacity-100 transition-opacity">
                                            <div class="absolute bottom-0 left-0 right-0 p-8">
                                                <div class="flex gap-4 mb-4 opacity-0 translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                                                    <?php if (!empty($member['linkedin_url']['url'])) : ?>
                                                        <a href="<?php echo esc_url($member['linkedin_url']['url']); ?>"
                                                            style="--hover-color: <?php echo esc_attr($primary_color); ?>;"
                                                            class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white"
                                                            <?php echo $member['linkedin_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                            <i class="<?php echo esc_attr($member['linkedin_icon']['value']); ?>"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if (!empty($member['twitter_url']['url'])) : ?>
                                                        <a href="<?php echo esc_url($member['twitter_url']['url']); ?>"
                                                            style="--hover-color: <?php echo esc_attr($primary_color); ?>;"
                                                            class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white"
                                                            <?php echo $member['twitter_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                            <i class="<?php echo esc_attr($member['twitter_icon']['value']); ?>"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if (!empty($member['facebook_url']['url'])) : ?>
                                                        <a href="<?php echo esc_url($member['facebook_url']['url']); ?>"
                                                            style="--hover-color: <?php echo esc_attr($primary_color); ?>;"
                                                            class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white"
                                                            <?php echo $member['facebook_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                            <i class="<?php echo esc_attr($member['facebook_icon']['value']); ?>"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if (!empty($member['instagram_url']['url'])) : ?>
                                                        <a href="<?php echo esc_url($member['instagram_url']['url']); ?>"
                                                            style="--hover-color: <?php echo esc_attr($primary_color); ?>;"
                                                            class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white"
                                                            <?php echo $member['instagram_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                            <i class="<?php echo esc_attr($member['instagram_icon']['value']); ?>"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="space-y-2 opacity-0 translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300 delay-100">
                                                    <div class="text-white text-lg font-semibold"><?php echo esc_html($member['name']); ?></div>
                                                    <div class="text-gray-300"><?php echo esc_html($member['position']); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Core Team -->
                <?php if (!empty($settings['core_team_members'])) :
                    $counter = 1; ?>
                    <div>
                        <h3 class="text-4xl font-bold text-gray-900 mb-12 text-center fade-in-effect">
                            <?php echo esc_html($settings['core_team_heading']); ?>
                        </h3>
                        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6 sm:gap-8">
                            <?php foreach ($settings['core_team_members'] as $member) : ?>
                                <div class="group relative fade-in-effect effect-<?php echo esc_attr($counter); ?>">
                                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                    <div class="relative bg-white rounded-xl overflow-hidden shadow-lg hover:shadow-xl transition-shadow duration-300">
                                        <div class="aspect-square overflow-hidden">
                                            <?php
                                            if (!empty($member['image']['id'])) {
                                                echo wp_get_attachment_image($member['image']['id'], 'full', false, [
                                                    'class' => 'w-full h-full object-cover transform transition-transform duration-700 group-hover:scale-110'
                                                ]);
                                            }
                                            ?>
                                        </div>
                                        <div class="p-6">
                                            <h4 class="text-lg font-semibold text-gray-900 mt-0"><?php echo esc_html($member['name']); ?></h4>
                                            <p class="text-gray-600 text-sm my-0"><?php echo esc_html($member['position']); ?></p>
                                            <div class="mt-4 flex gap-3">
                                                <?php if (!empty($member['linkedin_url']['url'])) : ?>
                                                    <a href="<?php echo esc_url($member['linkedin_url']['url']); ?>"
                                                        class="text-gray-400 hover:text-primary-amber transition-colors"
                                                        <?php echo $member['linkedin_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                        <i class="<?php echo esc_attr($member['linkedin_icon']['value']); ?>"></i>
                                                    </a>
                                                <?php endif; ?>

                                                <?php if (!empty($member['twitter_url']['url'])) : ?>
                                                    <a href="<?php echo esc_url($member['twitter_url']['url']); ?>"
                                                        class="text-gray-400 hover:text-amber-400 transition-colors"
                                                        <?php echo $member['twitter_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                        <i class="<?php echo esc_attr($member['twitter_icon']['value']); ?>"></i>
                                                    </a>
                                                <?php endif; ?>

                                                <?php if (!empty($member['facebook_url']['url'])) : ?>
                                                    <a href="<?php echo esc_url($member['facebook_url']['url']); ?>"
                                                        class="text-gray-400 hover:text-primary-amber transition-colors"
                                                        <?php echo $member['facebook_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                        <i class="<?php echo esc_attr($member['facebook_icon']['value']); ?>"></i>
                                                    </a>
                                                <?php endif; ?>

                                                <?php if (!empty($member['instagram_url']['url'])) : ?>
                                                    <a href="<?php echo esc_url($member['instagram_url']['url']); ?>"
                                                        class="text-gray-400 hover:text-pink-600 transition-colors"
                                                        <?php echo $member['instagram_url']['is_external'] ? 'target="_blank"' : ''; ?>>
                                                        <i class="<?php echo esc_attr($member['instagram_icon']['value']); ?>"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php
                                $counter++;
                            endforeach; ?>

                            <!-- Join Team Section -->
                            <div class="col-span-full mt-16 fade-in-effect ">
                                <div class="relative group">
                                    <div style="background-color: <?php echo esc_attr($primary_color); ?>" class="absolute -inset-1   rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                    <div style="background-color: <?php echo esc_attr($primary_color); ?>" class="relative  rounded-2xl p-8 text-center shadow-amber-200 shadow-lg ">
                                        <div class="mb-4">
                                            <div class="w-16 h-16 bg-gradient-to-br from-amber-50 to-purple-50 rounded-xl flex items-center justify-center mx-auto">
                                                <svg style="color: <?php echo esc_attr($primary_color); ?>" class="w-8 h-8  0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                                                </svg>
                                            </div>
                                        </div>
                                        <h3 class="text-xl font-bold text-white mb-2 "><?php echo esc_html($settings['join_title']); ?></h3>
                                        <p class="text-white mb-6"><?php echo wp_kses_post($settings['join_description']); ?></p>
                                        <?php if (!empty($settings['button_url']['url'])) : ?>
                                            <a style="color: <?php echo esc_attr($primary_color); ?>" href="<?php echo esc_url($settings['button_url']['url']); ?>"
                                                class="inline-flex items-center gap-2 px-6 py-3 bg-white   font-semibold rounded-xl   transition-all duration-300"
                                                <?php echo esc_attr($settings['button_url']['is_external'] ? 'target="_blank"' : ''); ?>>
                                                <?php echo esc_html($settings['button_text']); ?>
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                </svg>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    <?php
    }

    /**
     * Render widget in the editor.
     */
    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#FFB600' ;
            #>
            <section class="team-section py-16 sm:py-20 lg:py-20 overflow-hidden">
                <!-- Background Elements -->
                <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                        <div style="background-color: {{ primaryColor }}20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
                    </div>
                </div>

                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        {{{ settings.background_text }}}
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 ">
                        {{{ settings.heading_text }}}
                        <span style="color: {{ primaryColor }}">{{{ settings.heading_span }}}</span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto  ">
                        {{{ settings.section_description }}}
                    </p>
                </div>

                <!-- Leadership Team -->
                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <# if (settings.leadership_members && settings.leadership_members.length) { #>
                        <div class="mb-24">
                            <h3 class="text-4xl font-bold text-gray-900 mb-12 text-center  ">
                                {{{ settings.leadership_heading }}}
                            </h3>
                            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                                <# _.each(settings.leadership_members, function(member, index) { #>
                                    <div class="group relative  ">
                                        <div style="background-color: {{ primaryColor }}20" class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                        <div class="relative bg-white rounded-2xl overflow-hidden shadow-xl hover:shadow-2xl transition-shadow duration-300">
                                            <div class="aspect-[4/5] overflow-hidden">
                                                <# if (member.image.url) { #>
                                                    <img src="{{{ member.image.url }}}" class="w-full h-full object-cover transform transition-transform duration-700 group-hover:scale-110">
                                                    <# } #>
                                            </div>
                                            <div class="absolute inset-0 bg-gradient-to-t from-gray-900 via-gray-900/40 to-transparent opacity-0 group-hover:opacity-100 transition-opacity">
                                                <div class="absolute bottom-0 left-0 right-0 p-8">
                                                    <div class="flex gap-4 mb-4 opacity-0 translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                                                        <# if (member.linkedin_url && member.linkedin_url.url) { #>
                                                            <a href="{{ member.linkedin_url.url }}" style="--hover-color: {{ primaryColor }};" class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white">
                                                                <# if (member.linkedin_icon && member.linkedin_icon.value) { #>
                                                                    <i class="{{ member.linkedin_icon.value }}"></i>
                                                                    <# } #>
                                                            </a>
                                                            <# } #>

                                                                <# if (member.twitter_url && member.twitter_url.url) { #>
                                                                    <a href="{{ member.twitter_url.url }}" style="--hover-color: {{ primaryColor }};" class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white">
                                                                        <# if (member.twitter_icon && member.twitter_icon.value) { #>
                                                                            <i class="{{ member.twitter_icon.value }}"></i>
                                                                            <# } #>
                                                                    </a>
                                                                    <# } #>

                                                                        <# if (member.facebook_url && member.facebook_url.url) { #>
                                                                            <a href="{{ member.facebook_url.url }}" style="--hover-color: {{ primaryColor }};" class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white">
                                                                                <# if (member.facebook_icon && member.facebook_icon.value) { #>
                                                                                    <i class="{{ member.facebook_icon.value }}"></i>
                                                                                    <# } #>
                                                                            </a>
                                                                            <# } #>

                                                                                <# if (member.instagram_url && member.instagram_url.url) { #>
                                                                                    <a href="{{ member.instagram_url.url }}" style="--hover-color: {{ primaryColor }};" class="social-icon-link w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center backdrop-blur-sm transition-colors text-white">
                                                                                        <# if (member.instagram_icon && member.instagram_icon.value) { #>
                                                                                            <i class="{{ member.instagram_icon.value }}"></i>
                                                                                            <# } #>
                                                                                    </a>
                                                                                    <# } #>
                                                    </div>
                                                    <div class="space-y-2 opacity-0 translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300 delay-100">
                                                        <div class="text-white text-lg font-semibold">{{{ member.name }}}</div>
                                                        <div class="text-gray-300">{{{ member.position }}}</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <# }); #>
                            </div>
                        </div>
                        <# } #>

                            <!-- Core Team -->
                            <# if (settings.core_team_members && settings.core_team_members.length) { #>
                                <div>
                                    <h3 class="text-4xl font-bold text-gray-900 mb-12 text-center ">
                                        {{{ settings.core_team_heading }}}
                                    </h3>
                                    <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6 sm:gap-8">
                                        <# _.each(settings.core_team_members, function(member, index) { #>
                                            <div class="group relative">
                                                <div style="background-color: {{ primaryColor }}20" class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                                <div class="relative bg-white rounded-xl overflow-hidden shadow-lg hover:shadow-xl transition-shadow duration-300">
                                                    <div class="aspect-square overflow-hidden">
                                                        <# if (member.image.url) { #>
                                                            <img src="{{{ member.image.url }}}" class="w-full h-full object-cover transform transition-transform duration-700 group-hover:scale-110">
                                                            <# } #>
                                                    </div>
                                                    <div class="p-6">
                                                        <h4 class="text-lg font-semibold text-gray-900 mt-0">{{{ member.name }}}</h4>
                                                        <p class="text-gray-600 text-sm my-0">{{{ member.position }}}</p>
                                                        <div class="mt-4 flex gap-3">
                                                            <# if (member.linkedin_url && member.linkedin_url.url) { #>
                                                                <a href="{{ member.linkedin_url.url }}" class="text-gray-400 hover:text-primary-amber transition-colors">
                                                                    <# if (member.linkedin_icon && member.linkedin_icon.value) { #>
                                                                        <i class="{{ member.linkedin_icon.value }}"></i>
                                                                        <# } #>
                                                                </a>
                                                                <# } #>

                                                                    <# if (member.twitter_url && member.twitter_url.url) { #>
                                                                        <a href="{{ member.twitter_url.url }}" class="text-gray-400 hover:text-amber-400 transition-colors">
                                                                            <# if (member.twitter_icon && member.twitter_icon.value) { #>
                                                                                <i class="{{ member.twitter_icon.value }}"></i>
                                                                                <# } #>
                                                                        </a>
                                                                        <# } #>

                                                                            <# if (member.facebook_url && member.facebook_url.url) { #>
                                                                                <a href="{{ member.facebook_url.url }}" class="text-gray-400 hover:text-primary-amber transition-colors">
                                                                                    <# if (member.facebook_icon && member.facebook_icon.value) { #>
                                                                                        <i class="{{ member.facebook_icon.value }}"></i>
                                                                                        <# } #>
                                                                                </a>
                                                                                <# } #>

                                                                                    <# if (member.instagram_url && member.instagram_url.url) { #>
                                                                                        <a href="{{ member.instagram_url.url }}" class="text-gray-400 hover:text-pink-600 transition-colors">
                                                                                            <# if (member.instagram_icon && member.instagram_icon.value) { #>
                                                                                                <i class="{{ member.instagram_icon.value }}"></i>
                                                                                                <# } #>
                                                                                        </a>
                                                                                        <# } #>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <# }); #>

                                                <!-- Join Our Team Section -->
                                                <div class="col-span-full mt-16 ">
                                                    <div class="relative group">
                                                        <div style="background-color: {{ primaryColor }}" class="absolute -inset-1 rounded-2xl blur opacity-20 group-hover:opacity-30 transition-opacity"></div>
                                                        <div style="background-color: {{ primaryColor }}" class="relative rounded-2xl p-8 text-center shadow-amber-200 shadow-lg">
                                                            <div class="mb-4">
                                                                <div class="w-16 h-16 bg-gradient-to-br from-amber-50 to-purple-50 rounded-xl flex items-center justify-center mx-auto">
                                                                    <svg style="color: {{ primaryColor }}" class="w-8 h-8 0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                            <h3 class="text-xl font-bold text-white mb-2">{{{ settings.join_title }}}</h3>
                                                            <p class="text-white mb-6">{{{ settings.join_description }}}</p>
                                                            <# if (settings.button_url && settings.button_url.url) { #>
                                                                <a style="color: {{ primaryColor }}" href="{{ settings.button_url.url }}" class="inline-flex items-center gap-2 px-6 py-3 bg-white font-semibold rounded-xl transition-all duration-300">
                                                                    {{{ settings.button_text }}}
                                                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                                    </svg>
                                                                </a>
                                                                <# } #>
                                                        </div>
                                                    </div>
                                                </div>
                                    </div>
                                </div>
                                <# } #>
                </div>
            </section>
    <?php
    }
}
