<?php
class Testimonials_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'testimonials_section';
    }

    public function get_title()
    {
        return 'Client Testimonials Grid';
    }

    public function get_icon()
    {
        return 'eicon-testimonial-carousel';
    }

    public function get_categories()
    {
        return ['dhaara'];
    }

    protected function register_controls()
    {
        // Header Section
        $this->start_controls_section(
            'header_section',
            [
                'label' => 'Header',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => 'Background Text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Client Stories',
            ]
        );


        $this->add_control(
            'heading_text',
            [
                'label' => esc_html__('Heading', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Trusted by', 'dhaara-addon'),
            ]
        );

        $this->add_control(
            'heading_span',
            [
                'label' => esc_html__('Heading Span Text', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Testimonial', 'dhaara-addon'),
            ]
        );



        $this->add_control(
            'section_description',
            [
                'label' => 'Description',
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Don\'t just take our word for it - hear from some of our satisfied clients about their experience working with Dharā.',
            ]
        );

        $this->end_controls_section();

        // Testimonials Repeater
        $this->start_controls_section(
            'testimonials_section',
            [
                'label' => 'Testimonials',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => 'Client Image',
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => 'Client Name',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'John Doe',
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label' => 'Position',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'CEO, Company',
            ]
        );

        $repeater->add_control(
            'rating',
            [
                'label' => 'Rating (1-5)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 5,
            ]
        );

        $repeater->add_control(
            'testimonial',
            [
                'label' => 'Testimonial Text',
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Your testimonial text here.',
            ]
        );

        $repeater->add_control(
            'project_name',
            [
                'label' => 'Project Name',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Project Name',
            ]
        );

        $this->add_control(
            'testimonials_list',
            [
                'label' => 'Testimonials',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'name' => 'Sarah Chen',
                        'position' => 'CEO, TechVision Inc.',
                        'testimonial' => 'Dharā\'s commitment to sustainable architecture is unmatched. They seamlessly integrated eco-friendly solutions while maintaining the aesthetic appeal of our community center.',
                        'project_name' => 'Eco Community Hub',
                        'rating' => 5,
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();



        // Style Sections...
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Colors', 'dhaara-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'primary_color',
            [
                'label' => esc_html__('Primary Color', 'dhaara-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'global' => [
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $primary_color = !empty($settings['primary_color']) ? $settings['primary_color'] : '#FFB600';
        $counter = 1;
?>
        <section class="testimonials-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 -z-10">
                <!-- Gradient Orbs -->
                <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl"></div>
                    <div style="background-color: <?php echo esc_attr($primary_color); ?>20" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl animation-delay-2000"></div>
                </div>
            </div>
            <!-- Section Header -->
            <div class="relative mb-12 sm:mb-16 text-center z-10">
                <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                    <?php echo esc_html($settings['background_text']); ?>
                </div>
                <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 fade-in-effect">
                    <?php echo esc_html($settings['heading_text']); ?>
                    <span style="color: <?php echo esc_attr($primary_color); ?>"><?php echo esc_html($settings['heading_span']); ?></span>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto fade-in-effect effect-2">
                    <?php echo esc_html($settings['section_description']); ?>
                </p>
            </div>




            <!-- Testimonials Grid -->
            <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                    <?php foreach ($settings['testimonials_list'] as $testimonial) : ?>
                        <div class="group relative fade-in-effect effect-<?php echo esc_attr($counter); ?> ">
                            <div class="relative bg-white rounded-2xl p-8 shadow-xl hover:shadow-2xl transition-shadow duration-300 flex flex-col h-full">
                                <div class="flex items-center gap-4 mb-4">
                                    <div class="w-16 h-16 rounded-full overflow-hidden">
                                        <img src="<?php echo esc_url($testimonial['image']['url']); ?>" alt="<?php echo esc_attr($testimonial['name']); ?>" class="w-full h-full object-cover" />
                                    </div>
                                    <div>
                                        <h4 class="text-lg font-semibold text-gray-900 mt-0"><?php echo esc_html($testimonial['name']); ?></h4>
                                        <p class="text-gray-600 my-0"><?php echo esc_html($testimonial['position']); ?></p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <div class="flex gap-1">
                                        <?php for ($i = 0; $i < $testimonial['rating']; $i++) : ?>
                                            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                            </svg>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <p class="text-gray-600 leading-relaxed flex-1 my-0">
                                    <?php echo esc_html($testimonial['testimonial']); ?>
                                </p>
                                <div class="flex items-center justify-between">
                                    <span class="text-sm text-gray-500">Project: <?php echo esc_html($testimonial['project_name']); ?></span>
                                    <span class="w-8 h-8 rounded-full bg-amber-100 flex items-center justify-center">
                                        <svg style="color: <?php echo esc_attr($primary_color); ?>" class="w-4 h-4 " fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php
                        $counter++;
                    endforeach; ?>
                </div>
            </div>
        </section>
    <?php
    }

    protected function content_template()
    {
    ?>
        <#
            var primaryColor=settings.primary_color || '#FFB600' ;
            if ( settings.testimonials_list.length ) { #>

            <section class="testimonials-section relative py-16 sm:py-20 lg:py-20 overflow-hidden">
                <!-- Background Elements -->
                <div class="absolute inset-0 -z-10">
                    <!-- Gradient Orbs -->
                    <div class="absolute top-0 left-0 w-full h-full overflow-hidden">
                        <div style="background-color: {{ primaryColor }}20" class="bg-fade-effect absolute top-1/4 -left-20 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                        <div style="background-color: {{ primaryColor }}30" class="absolute bottom-1/4 right-0 w-96 h-96 rounded-full mix-blend-multiply filter blur-3xl float"></div>
                    </div>
                </div>

                <!-- Section Header -->
                <div class="relative mb-12 sm:mb-16 text-center z-10">
                    <div class="absolute -top-10 left-1/2 -translate-x-1/2 text-[80px] sm:text-[120px] font-bold text-gray-100 select-none opacity-0 md:opacity-60 leading-none -z-10">
                        {{{ settings.background_text }}}
                    </div>
                    <h2 class="relative text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 ">
                        {{{ settings.heading_text }}}
                        <span style="color: {{ primaryColor }}">{{{ settings.heading_span }}}</span>
                    </h2>
                    <p class="mt-4 text-xl text-gray-600 max-w-2xl mx-auto  ">
                        {{{ settings.section_description }}}
                    </p>
                </div>

                <!-- Testimonials Grid -->
                <div class="max-w-7xl 2xl:max-w-8xl mx-auto px-4">
                    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                        <# _.each(settings.testimonials_list, function(testimonial, index) { #>
                            <div class="group relative  ">
                                <div class="relative bg-white rounded-2xl p-8 shadow-xl hover:shadow-2xl transition-shadow duration-300 flex flex-col h-full">
                                    <div class="flex items-center gap-4 mb-4">
                                        <div class="w-16 h-16 rounded-full overflow-hidden">
                                            <img src="{{ testimonial.image.url }}" alt="{{ testimonial.name }}" class="w-full h-full object-cover" />
                                        </div>
                                        <div>
                                            <h4 class="text-lg font-semibold text-gray-900 mt-0">{{ testimonial.name }}</h4>
                                            <p class="text-gray-600 my-0">{{ testimonial.position }}</p>
                                        </div>
                                    </div>
                                    <div class="mb-4">
                                        <div class="flex gap-1">
                                            <# for(var i=0; i < testimonial.rating; i++) { #>
                                                <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                </svg>
                                                <# } #>
                                        </div>
                                    </div>
                                    <blockquote class="text-gray-600 leading-relaxed flex-1 my-0">
                                        {{ testimonial.testimonial }}
                                    </blockquote>
                                    <div class="flex items-center justify-between">
                                        <span class="text-sm text-gray-500">Project: {{ testimonial.project_name }}</span>
                                        <span class="w-8 h-8 rounded-full bg-amber-100 flex items-center justify-center">
                                            <svg style="color: {{ primaryColor }}" class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <# }); #>
                    </div>
                </div>
            </section>
            <# } #>
        <?php
    }
}
